/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofApiObject;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

class RestartProofKeyValueView<K, V>
extends RestartProofApiObject<KeyValueView<K, V>>
implements KeyValueView<K, V> {
    RestartProofKeyValueView(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, Function<Ignite, KeyValueView<K, V>> viewFactory) {
        super(attachmentLock, initialIgnite, viewFactory);
    }

    @Nullable
    public V get(@Nullable Transaction tx, K key) {
        return (V)this.attached(view -> view.get(tx, key));
    }

    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        return this.attachedAsync(view -> view.getAsync(tx, key));
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        return this.attached(view -> view.getNullable(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        return this.attachedAsync(view -> view.getNullableAsync(tx, key));
    }

    @Nullable
    public V getOrDefault(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return (V)this.attached(view -> view.getOrDefault(tx, key, defaultValue));
    }

    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.attachedAsync(view -> view.getOrDefaultAsync(tx, key, defaultValue));
    }

    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.attached(view -> view.getAll(tx, keys));
    }

    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.attachedAsync(view -> view.getAllAsync(tx, keys));
    }

    public boolean contains(@Nullable Transaction tx, K key) {
        return this.attached(view -> view.contains(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        return this.attachedAsync(view -> view.containsAsync(tx, key));
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.attached(view -> view.containsAll(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.attachedAsync(view -> view.containsAllAsync(tx, keys));
    }

    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        this.consumeAttached(view -> view.put(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.putAsync(tx, key, val));
    }

    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        this.consumeAttached(view -> view.putAll(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        return this.attachedAsync(view -> view.putAllAsync(tx, pairs));
    }

    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return (V)this.attached(view -> view.getAndPut(tx, key, val));
    }

    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.getAndPutAsync(tx, key, val));
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attached(view -> view.getNullableAndPut(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.getNullableAndPutAsync(tx, key, val));
    }

    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attached(view -> view.putIfAbsent(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.putIfAbsentAsync(tx, key, val));
    }

    public boolean remove(@Nullable Transaction tx, K key) {
        return this.attached(view -> view.remove(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return this.attached(view -> view.remove(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        return this.attachedAsync(view -> view.removeAsync(tx, key));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        return this.attachedAsync(view -> view.removeAsync(tx, key, val));
    }

    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.attached(view -> view.removeAll(tx, keys));
    }

    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.attachedAsync(view -> view.removeAllAsync(tx, keys));
    }

    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        return (V)this.attached(view -> view.getAndRemove(tx, key));
    }

    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        return this.attachedAsync(view -> view.getAndRemoveAsync(tx, key));
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.attached(view -> view.getNullableAndRemove(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        return this.attachedAsync(view -> view.getNullableAndRemoveAsync(tx, key));
    }

    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attached(view -> view.replace(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, K key, @Nullable V oldValue, @Nullable V newValue) {
        return this.attached(view -> view.replace(tx, key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.replaceAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        return this.attachedAsync(view -> view.replaceAsync(tx, key, oldVal, newVal));
    }

    @Nullable
    public V getAndReplace(@Nullable Transaction tx, @Nullable K key, @Nullable V val) {
        return (V)this.attached(view -> view.getAndReplace(tx, key, val));
    }

    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.getAndReplaceAsync(tx, key, val));
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attached(view -> view.getNullableAndReplace(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.attachedAsync(view -> view.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        return this.attachedAsync(view -> view.streamData(publisher, options));
    }

    public <E, V1, R, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, Map.Entry<K, V>> keyFunc, Function<E, V1> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options, @Nullable A receiverArg) {
        return this.attachedAsync(view -> view.streamData(publisher, keyFunc, payloadFunc, receiver, resultSubscriber, options, receiverArg));
    }

    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.attached(view -> view.query(tx, criteria, indexName, opts));
    }

    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.attachedAsync(view -> view.queryAsync(tx, criteria, indexName, opts));
    }
}

