/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite.internal.catalog.commands.AlterZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.AlterZoneEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.jetbrains.annotations.Nullable;

public class AlterZoneCommand
extends AbstractZoneCommand {
    private final boolean ifExists;
    @Nullable
    private final Integer partitions;
    @Nullable
    private final Integer replicas;
    @Nullable
    private final Integer dataNodesAutoAdjust;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleUp;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleDown;
    @Nullable
    private final String filter;
    @Nullable
    private final List<StorageProfileParams> storageProfileParams;

    public static AlterZoneCommandBuilder builder() {
        return new Builder();
    }

    private AlterZoneCommand(String zoneName, boolean ifExists, @Nullable Integer partitions, @Nullable Integer replicas, @Nullable Integer dataNodesAutoAdjust, @Nullable Integer dataNodesAutoAdjustScaleUp, @Nullable Integer dataNodesAutoAdjustScaleDown, @Nullable String filter, @Nullable List<StorageProfileParams> storageProfileParams) throws CatalogValidationException {
        super(zoneName);
        this.ifExists = ifExists;
        this.partitions = partitions;
        this.replicas = replicas;
        this.dataNodesAutoAdjust = dataNodesAutoAdjust;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfileParams = storageProfileParams;
        this.validate();
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogZoneDescriptor zone = CatalogUtils.zoneOrThrow(catalog, this.zoneName);
        CatalogZoneDescriptor descriptor = this.fromParamsAndPreviousValue(zone);
        return List.of(new AlterZoneEntry(descriptor));
    }

    private CatalogZoneDescriptor fromParamsAndPreviousValue(CatalogZoneDescriptor previous) {
        @Nullable Integer autoAdjust = null;
        @Nullable Integer scaleUp = null;
        Integer scaleDown = null;
        if (this.dataNodesAutoAdjust != null) {
            autoAdjust = this.dataNodesAutoAdjust;
            scaleUp = Integer.MAX_VALUE;
            scaleDown = Integer.MAX_VALUE;
        } else if (this.dataNodesAutoAdjustScaleUp != null || this.dataNodesAutoAdjustScaleDown != null) {
            autoAdjust = Integer.MAX_VALUE;
            scaleUp = this.dataNodesAutoAdjustScaleUp;
            scaleDown = this.dataNodesAutoAdjustScaleDown;
        }
        CatalogStorageProfilesDescriptor storageProfiles = this.storageProfileParams != null ? CatalogUtils.fromParams(this.storageProfileParams) : previous.storageProfiles();
        return new CatalogZoneDescriptor(previous.id(), previous.name(), Objects.requireNonNullElse(this.partitions, previous.partitions()), Objects.requireNonNullElse(this.replicas, previous.replicas()), Objects.requireNonNullElse(autoAdjust, previous.dataNodesAutoAdjust()), Objects.requireNonNullElse(scaleUp, previous.dataNodesAutoAdjustScaleUp()), Objects.requireNonNullElse(scaleDown, previous.dataNodesAutoAdjustScaleDown()), Objects.requireNonNullElse(this.filter, previous.filter()), storageProfiles, previous.consistencyMode());
    }

    private void validate() {
        CatalogParamsValidationUtils.validatePartition(this.partitions);
        CatalogParamsValidationUtils.validateField(this.replicas, 1, null, "Invalid number of replicas");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjust, 0, null, "Invalid data nodes auto adjust");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleUp, 0, null, "Invalid data nodes auto adjust scale up");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleDown, 0, null, "Invalid data nodes auto adjust scale down");
        CatalogParamsValidationUtils.validateZoneDataNodesAutoAdjustParametersCompatibility(this.dataNodesAutoAdjust, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown);
        CatalogParamsValidationUtils.validateZoneFilter(this.filter);
    }

    private static class Builder
    implements AlterZoneCommandBuilder {
        private String zoneName;
        private boolean ifExists;
        @Nullable
        private Integer partitions;
        @Nullable
        private Integer replicas;
        @Nullable
        private Integer dataNodesAutoAdjust;
        @Nullable
        private Integer dataNodesAutoAdjustScaleUp;
        @Nullable
        private Integer dataNodesAutoAdjustScaleDown;
        @Nullable
        private String filter;
        @Nullable
        private List<StorageProfileParams> storageProfileParams;

        private Builder() {
        }

        @Override
        public AlterZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder partitions(Integer partitions) {
            this.partitions = partitions;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder dataNodesAutoAdjust(Integer adjust) {
            this.dataNodesAutoAdjust = adjust;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder dataNodesAutoAdjustScaleUp(Integer adjust) {
            this.dataNodesAutoAdjustScaleUp = adjust;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder dataNodesAutoAdjustScaleDown(Integer adjust) {
            this.dataNodesAutoAdjustScaleDown = adjust;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder storageProfilesParams(@Nullable List<StorageProfileParams> params) {
            this.storageProfileParams = params;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterZoneCommand(this.zoneName, this.ifExists, this.partitions, this.replicas, this.dataNodesAutoAdjust, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown, this.filter, this.storageProfileParams);
        }
    }
}

