/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropColumnEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class DropColumnsEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<DropColumnsEntry> SERIALIZER = new DropColumnEntrySerializer();
    private final int tableId;
    private final Set<String> columns;

    public DropColumnsEntry(int tableId, Set<String> columns) {
        this.tableId = tableId;
        this.columns = columns;
    }

    public int tableId() {
        return this.tableId;
    }

    public Set<String> columns() {
        return this.columns;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_COLUMN.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropColumnEventParameters(causalityToken, catalogVersion, this.tableId, this.columns);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.tableId);
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        CatalogTableDescriptor newTable = table.newDescriptor(table.name(), table.tableVersion() + 1, table.columns().stream().filter(col -> !this.columns.contains(col.name())).collect(Collectors.toList()), causalityToken, table.storageProfile());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(CatalogUtils.replaceTable(schema, newTable), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class DropColumnEntrySerializer
    implements CatalogObjectSerializer<DropColumnsEntry> {
        private DropColumnEntrySerializer() {
        }

        @Override
        public DropColumnsEntry readFrom(IgniteDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            Set columns = CatalogSerializationUtils.readStringCollection(input, size -> new HashSet(IgniteUtils.capacity((int)size)));
            return new DropColumnsEntry(tableId, columns);
        }

        @Override
        public void writeTo(DropColumnsEntry object, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)object.tableId());
            CatalogSerializationUtils.writeStringCollection(object.columns(), output);
        }
    }
}

