/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.Arrays;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class DropTableEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<DropTableEntry> SERIALIZER = new DropTableEntrySerializer();
    private final int tableId;

    public DropTableEntry(int tableId) {
        this.tableId = tableId;
    }

    public int tableId() {
        return this.tableId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_TABLE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_DROP;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropTableEventParameters(causalityToken, catalogVersion, this.tableId);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.tableId);
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), (CatalogTableDescriptor[])Arrays.stream(schema.tables()).filter(t -> t.id() != this.tableId).toArray(CatalogTableDescriptor[]::new), schema.indexes(), schema.systemViews(), causalityToken), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class DropTableEntrySerializer
    implements CatalogObjectSerializer<DropTableEntry> {
        private DropTableEntrySerializer() {
        }

        @Override
        public DropTableEntry readFrom(IgniteDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            return new DropTableEntry(tableId);
        }

        @Override
        public void writeTo(DropTableEntry entry, IgniteDataOutput out) throws IOException {
            out.writeVarInt((long)entry.tableId());
        }
    }
}

