/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.systemviews;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.systemview.api.ClusterSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;

public class SystemViewViewProvider
implements CatalogSystemViewProvider {
    private static final int SYSTEM_VIEW_STRING_COLUMN_LENGTH = Short.MAX_VALUE;

    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        SystemView<?> systemViewsView = SystemViewViewProvider.getSystemViewView(catalogSupplier);
        SystemView<?> systemViewColumnsView = SystemViewViewProvider.getSystemViewColumnsView(catalogSupplier);
        return List.of(systemViewsView, systemViewColumnsView);
    }

    private static SystemView<?> getSystemViewView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.schemas().stream().flatMap(schema -> Arrays.stream(schema.systemViews()).map(viewDescriptor -> new ViewWithSchema((CatalogSystemViewDescriptor)viewDescriptor, schema.name()))).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("SYSTEM_VIEWS")).addColumn("ID", NativeTypes.INT32, entry -> entry.descriptor.id())).addColumn("SCHEMA", NativeTypes.stringOf((int)Short.MAX_VALUE), entry -> entry.schema)).addColumn("NAME", NativeTypes.stringOf((int)Short.MAX_VALUE), entry -> entry.descriptor.name())).addColumn("TYPE", NativeTypes.stringOf((int)Short.MAX_VALUE), entry -> entry.descriptor.systemViewType().name())).dataProvider(viewDataPublisher)).build();
    }

    private static SystemView<?> getSystemViewColumnsView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.schemas().stream().flatMap(schema -> Arrays.stream(schema.systemViews())).flatMap(viewDescriptor -> viewDescriptor.columns().stream().map(columnDescriptor -> new ColumnWithTableId((CatalogTableColumnDescriptor)columnDescriptor, viewDescriptor.id()))).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("SYSTEM_VIEW_COLUMNS")).addColumn("VIEW_ID", NativeTypes.INT32, entry -> entry.id)).addColumn("NAME", NativeTypes.stringOf((int)Short.MAX_VALUE), entry -> entry.descriptor.name())).addColumn("TYPE", NativeTypes.stringOf((int)Short.MAX_VALUE), entry -> entry.descriptor.type().name())).addColumn("NULLABLE", NativeTypes.BOOLEAN, entry -> entry.descriptor.nullable())).addColumn("PRECISION", NativeTypes.INT32, entry -> entry.descriptor.precision())).addColumn("SCALE", NativeTypes.INT32, entry -> entry.descriptor.scale())).addColumn("LENGTH", NativeTypes.INT32, entry -> entry.descriptor.length())).dataProvider(viewDataPublisher)).build();
    }

    private static class ColumnWithTableId {
        final CatalogTableColumnDescriptor descriptor;
        final int id;

        ColumnWithTableId(CatalogTableColumnDescriptor descriptor, int id) {
            this.descriptor = descriptor;
            this.id = id;
        }
    }

    private static class ViewWithSchema {
        final CatalogSystemViewDescriptor descriptor;
        final String schema;

        ViewWithSchema(CatalogSystemViewDescriptor descriptor, String schema) {
            this.descriptor = descriptor;
            this.schema = schema;
        }
    }
}

