/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.otlp;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.PushMetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.metrics.exporters.configuration.OtlpExporterView;
import org.apache.ignite.internal.metrics.exporters.otlp.MetricReporter;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@AutoService(value={MetricExporter.class})
public class OtlpPushMetricExporter
extends PushMetricExporter<OtlpExporterView> {
    public static final String EXPORTER_NAME = "otlp";
    private final AtomicReference<MetricReporter> reporter = new AtomicReference();

    public synchronized void stop() {
        super.stop();
        this.changeReporter(null);
    }

    public synchronized void reconfigure(OtlpExporterView newVal) {
        MetricReporter newReporter = new MetricReporter(newVal, () -> this.clusterId(), this.nodeName());
        for (MetricSet metricSet : ((Map)this.metrics().getKey()).values()) {
            newReporter.addMetricSet(metricSet);
        }
        this.changeReporter(newReporter);
        super.reconfigure((ExporterView)newVal);
    }

    public void addMetricSet(MetricSet metricSet) {
        MetricReporter reporter0 = this.reporter.get();
        assert (reporter0 != null);
        reporter0.addMetricSet(metricSet);
    }

    public void removeMetricSet(String metricSetName) {
        MetricReporter reporter0 = this.reporter.get();
        assert (reporter0 != null);
        reporter0.removeMetricSet(metricSetName);
    }

    protected long period() {
        return ((OtlpExporterView)this.configuration()).period();
    }

    public void report() {
        MetricReporter reporter0 = this.reporter.get();
        assert (reporter0 != null);
        reporter0.report();
    }

    public String name() {
        return EXPORTER_NAME;
    }

    @TestOnly
    @Nullable
    MetricReporter reporter() {
        return this.reporter.get();
    }

    private void changeReporter(@Nullable MetricReporter newReporter) {
        MetricReporter oldReporter = this.reporter.getAndSet(newReporter);
        try {
            IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{oldReporter});
        }
        catch (Exception e) {
            this.log.error("Failed to stop metric exporter: " + this.name(), (Throwable)e);
        }
    }
}

