/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.tx.impl.IgniteAbstractTransactionImpl;
import org.apache.ignite.internal.tx.impl.TransactionsExceptionMapperUtil;
import org.apache.ignite.internal.tx.impl.TxIdAndTimestamp;
import org.apache.ignite.internal.tx.impl.TxManagerImpl;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;

public class ReadOnlyTransactionImpl
extends IgniteAbstractTransactionImpl {
    private final HybridTimestamp readTimestamp;
    private final AtomicBoolean finishGuard = new AtomicBoolean();
    private final CompletableFuture<Void> txFuture;

    ReadOnlyTransactionImpl(TxManagerImpl txManager, HybridTimestampTracker observableTsTracker, UUID id, UUID txCoordinatorId, boolean implicit, HybridTimestamp readTimestamp, CompletableFuture<Void> txFuture) {
        super(txManager, observableTsTracker, id, txCoordinatorId, implicit);
        this.readTimestamp = readTimestamp;
        this.txFuture = txFuture;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public HybridTimestamp startTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlist(TablePartitionId tablePartitionId, IgniteBiTuple<ClusterNode, Long> nodeAndConsistencyToken) {
        return null;
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlistedNodeAndConsistencyToken(TablePartitionId tablePartitionId) {
        return null;
    }

    @Override
    public boolean assignCommitPartition(TablePartitionId tablePartitionId) {
        return true;
    }

    @Override
    public TablePartitionId commitPartition() {
        return null;
    }

    public CompletableFuture<Void> commitAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(true, this.readTimestamp, false), ErrorGroups.Transactions.TX_COMMIT_ERR);
    }

    public CompletableFuture<Void> rollbackAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, this.readTimestamp, false), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> finish(boolean commit, HybridTimestamp executionTimestamp, boolean full) {
        assert (!full) : "Read-only transactions cannot be full.";
        if (!this.finishGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.observableTsTracker.update(executionTimestamp);
        this.txFuture.complete(null);
        ((TxManagerImpl)this.txManager).completeReadOnlyTransactionFuture(new TxIdAndTimestamp(this.readTimestamp, this.id()));
        return this.txFuture;
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.finishGuard.get();
    }
}

