/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.node.metric;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.NodeMetricApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.MetricSet;

@Singleton
public class NodeMetricSetListCall
implements Call<UrlCallInput, List<MetricSet>> {
    private final ApiClientFactory clientFactory;

    public NodeMetricSetListCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<List<MetricSet>> execute(UrlCallInput input) {
        try {
            return DefaultCallOutput.success(this.listNodeMetricSets(input));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getUrl()));
        }
    }

    private List<MetricSet> listNodeMetricSets(UrlCallInput input) throws ApiException {
        return new NodeMetricApi(this.clientFactory.getClient(input.getUrl())).listNodeMetricSets();
    }
}

