/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogSystemViewRegistry;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.CatalogVersionAwareValidationException;
import org.apache.ignite.internal.catalog.UpdateProducer;
import org.apache.ignite.internal.catalog.commands.AlterZoneSetDefaultCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.CreateSchemaCommand;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommand;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.SnapshotEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateLog;
import org.apache.ignite.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite.internal.catalog.storage.VersionedUpdate;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class CatalogManagerImpl
extends AbstractEventProducer<CatalogEvent, CatalogEventParameters>
implements CatalogManager,
SystemViewProvider {
    public static final String DEFAULT_ZONE_NAME = "Default";
    private static final int MAX_RETRY_COUNT = 10;
    static final int DEFAULT_DELAY_DURATION = 0;
    static final int DEFAULT_PARTITION_IDLE_SAFE_TIME_PROPAGATION_PERIOD = 0;
    public static final long INITIAL_CAUSALITY_TOKEN = 0L;
    private static final IgniteLogger LOG = Loggers.forClass(CatalogManagerImpl.class);
    private final NavigableMap<Integer, Catalog> catalogByVer = new ConcurrentSkipListMap<Integer, Catalog>();
    private final NavigableMap<Long, Catalog> catalogByTs = new ConcurrentSkipListMap<Long, Catalog>();
    private final CompletableFuture<Void> catalogInitializationFuture = new CompletableFuture();
    private final UpdateLog updateLog;
    private final PendingComparableValuesTracker<Integer, Void> versionTracker = new PendingComparableValuesTracker((Comparable)Integer.valueOf(0));
    private final ClockService clockService;
    private final LongSupplier delayDurationMsSupplier;
    private final CatalogSystemViewRegistry catalogSystemViewProvider;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private CompletableFuture<Void> lastSaveUpdateFuture = CompletableFutures.nullCompletedFuture();
    private final Object lastSaveUpdateFutureMutex = new Object();

    public CatalogManagerImpl(UpdateLog updateLog, ClockService clockService) {
        this(updateLog, clockService, () -> 0L);
    }

    public CatalogManagerImpl(UpdateLog updateLog, ClockService clockService, LongSupplier delayDurationMsSupplier) {
        this.updateLog = updateLog;
        this.clockService = clockService;
        this.delayDurationMsSupplier = delayDurationMsSupplier;
        this.catalogSystemViewProvider = new CatalogSystemViewRegistry(() -> this.catalogAt(clockService.nowLong()));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        int objectIdGen = 0;
        Catalog emptyCatalog = new Catalog(0, 0L, objectIdGen, List.of(), List.of(), null);
        this.registerCatalog(emptyCatalog);
        this.updateLog.registerUpdateHandler(new OnUpdateHandlerImpl());
        return this.updateLog.startAsync(componentContext).thenComposeAsync(none -> {
            if (this.latestCatalogVersion() == emptyCatalog.version()) {
                int initializedCatalogVersion = emptyCatalog.version() + 1;
                ((CompletableFuture)this.catalogReadyFuture(initializedCatalogVersion).thenComposeAsync(ignored -> this.awaitVersionActivation(initializedCatalogVersion), (Executor)componentContext.executor())).handleAsync((r, e) -> this.catalogInitializationFuture.complete(null), (Executor)componentContext.executor());
                return this.initCatalog(emptyCatalog);
            }
            this.catalogInitializationFuture.complete(null);
            return CompletableFutures.nullCompletedFuture();
        }, (Executor)componentContext.executor());
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.busyLock.block();
        this.versionTracker.close();
        return this.updateLog.stopAsync(componentContext);
    }

    @Override
    @Nullable
    public CatalogTableDescriptor table(String tableName, long timestamp) {
        CatalogSchemaDescriptor schema = this.catalogAt(timestamp).schema("PUBLIC");
        if (schema == null) {
            return null;
        }
        return schema.table(tableName);
    }

    @Override
    @Nullable
    public CatalogTableDescriptor table(int tableId, long timestamp) {
        return this.catalogAt(timestamp).table(tableId);
    }

    @Override
    @Nullable
    public CatalogTableDescriptor table(int tableId, int catalogVersion) {
        return this.catalog(catalogVersion).table(tableId);
    }

    @Override
    public Collection<CatalogTableDescriptor> tables(int catalogVersion) {
        return this.catalog(catalogVersion).tables();
    }

    @Override
    @Nullable
    public CatalogIndexDescriptor aliveIndex(String indexName, long timestamp) {
        CatalogSchemaDescriptor schema = this.catalogAt(timestamp).schema("PUBLIC");
        if (schema == null) {
            return null;
        }
        return schema.aliveIndex(indexName);
    }

    @Override
    @Nullable
    public CatalogIndexDescriptor index(int indexId, long timestamp) {
        return this.catalogAt(timestamp).index(indexId);
    }

    @Override
    @Nullable
    public CatalogIndexDescriptor index(int indexId, int catalogVersion) {
        return this.catalog(catalogVersion).index(indexId);
    }

    @Override
    public Collection<CatalogIndexDescriptor> indexes(int catalogVersion) {
        return this.catalog(catalogVersion).indexes();
    }

    @Override
    public List<CatalogIndexDescriptor> indexes(int catalogVersion, int tableId) {
        return this.catalog(catalogVersion).indexes(tableId);
    }

    @Override
    @Nullable
    public CatalogSchemaDescriptor schema(int catalogVersion) {
        return this.schema("PUBLIC", catalogVersion);
    }

    @Override
    @Nullable
    public CatalogSchemaDescriptor schema(String schemaName, int catalogVersion) {
        Catalog catalog = this.catalog(catalogVersion);
        if (catalog == null) {
            return null;
        }
        return catalog.schema(schemaName == null ? "PUBLIC" : schemaName);
    }

    @Override
    @Nullable
    public CatalogSchemaDescriptor schema(int schemaId, int catalogVersion) {
        Catalog catalog = this.catalog(catalogVersion);
        return catalog == null ? null : catalog.schema(schemaId);
    }

    @Override
    @Nullable
    public CatalogZoneDescriptor zone(String zoneName, long timestamp) {
        return this.catalogAt(timestamp).zone(zoneName);
    }

    @Override
    @Nullable
    public CatalogZoneDescriptor zone(int zoneId, long timestamp) {
        return this.catalogAt(timestamp).zone(zoneId);
    }

    @Override
    @Nullable
    public CatalogZoneDescriptor zone(int zoneId, int catalogVersion) {
        return this.catalog(catalogVersion).zone(zoneId);
    }

    @Override
    public Collection<CatalogZoneDescriptor> zones(int catalogVersion) {
        return this.catalog(catalogVersion).zones();
    }

    @Override
    @Nullable
    public CatalogSchemaDescriptor activeSchema(long timestamp) {
        return this.catalogAt(timestamp).schema("PUBLIC");
    }

    @Override
    @Nullable
    public CatalogSchemaDescriptor activeSchema(String schemaName, long timestamp) {
        return this.catalogAt(timestamp).schema(schemaName == null ? "PUBLIC" : schemaName);
    }

    @Override
    public int activeCatalogVersion(long timestamp) {
        return this.catalogAt(timestamp).version();
    }

    @Override
    public int earliestCatalogVersion() {
        return this.catalogByVer.firstEntry().getKey();
    }

    @Override
    public int latestCatalogVersion() {
        return this.catalogByVer.lastEntry().getKey();
    }

    @Override
    public CompletableFuture<Void> catalogReadyFuture(int version) {
        return this.versionTracker.waitFor((Comparable)Integer.valueOf(version));
    }

    @Override
    public CompletableFuture<Void> catalogInitializationFuture() {
        return this.catalogInitializationFuture;
    }

    @Override
    @Nullable
    public Catalog catalog(int catalogVersion) {
        return (Catalog)this.catalogByVer.get(catalogVersion);
    }

    private Catalog catalogAt(long timestamp) {
        Map.Entry<Long, Catalog> entry = this.catalogByTs.floorEntry(timestamp);
        if (entry == null) {
            throw new IllegalStateException("No valid schema found for given timestamp: " + timestamp);
        }
        return entry.getValue();
    }

    @Override
    public CompletableFuture<Integer> execute(CatalogCommand command) {
        return this.saveUpdateAndWaitForActivation(command);
    }

    @Override
    public CompletableFuture<Integer> execute(List<CatalogCommand> commands) {
        if (CollectionUtils.nullOrEmpty(commands)) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.saveUpdateAndWaitForActivation(new BulkUpdateProducer(List.copyOf(commands)));
    }

    public CompletableFuture<Boolean> compactCatalog(int version) {
        Catalog catalog = this.catalog(version);
        if (catalog == null) {
            throw new IllegalArgumentException("Catalog version not found: " + version);
        }
        return this.updateLog.saveSnapshot(new SnapshotEntry(catalog));
    }

    private CompletableFuture<Void> initCatalog(Catalog emptyCatalog) {
        List<CatalogCommand> initCommands = List.of(((CreateZoneCommandBuilder)CreateZoneCommand.builder().zoneName(DEFAULT_ZONE_NAME)).partitions(25).replicas(1).dataNodesAutoAdjustScaleUp(0).dataNodesAutoAdjustScaleDown(Integer.MAX_VALUE).filter("$..*").storageProfilesParams(List.of(StorageProfileParams.builder().storageProfile("default").build())).build(), AlterZoneSetDefaultCommand.builder().zoneName(DEFAULT_ZONE_NAME).build(), CreateSchemaCommand.builder().name("PUBLIC").build(), CreateSchemaCommand.builder().name("SYSTEM").build());
        List<UpdateEntry> entries = new BulkUpdateProducer(initCommands).get(emptyCatalog);
        return this.updateLog.append(new VersionedUpdate(emptyCatalog.version() + 1, 0L, entries)).handle((result, error) -> {
            if (error != null) {
                LOG.warn("Unable to create default zone.", error);
            }
            return null;
        });
    }

    private void registerCatalog(Catalog newCatalog) {
        this.catalogByVer.put(newCatalog.version(), newCatalog);
        this.catalogByTs.put(newCatalog.time(), newCatalog);
    }

    private void truncateUpTo(Catalog catalog) {
        this.catalogByVer.headMap(catalog.version(), false).clear();
        this.catalogByTs.headMap(catalog.time(), false).clear();
        LOG.info("Catalog history was truncated up to version=" + catalog.version(), new Object[0]);
    }

    private CompletableFuture<Integer> saveUpdateAndWaitForActivation(UpdateProducer updateProducer) {
        CompletableFuture<Integer> resultFuture = new CompletableFuture<Integer>();
        ((CompletableFuture)this.saveUpdateEliminatingLocalConcurrency(updateProducer).thenCompose(this::awaitVersionActivation)).whenComplete((newVersion, err) -> {
            if (err != null) {
                Throwable errUnwrapped = ExceptionUtils.unwrapCause((Throwable)err);
                if (errUnwrapped instanceof CatalogVersionAwareValidationException) {
                    CatalogVersionAwareValidationException err0 = (CatalogVersionAwareValidationException)((Object)((Object)errUnwrapped));
                    Catalog catalog = (Catalog)this.catalogByVer.get(err0.version());
                    Throwable error = err0.initial();
                    if (catalog.version() == 0) {
                        resultFuture.completeExceptionally(error);
                    } else {
                        HybridTimestamp tsSafeForRoReadingInPastOptimization = this.calcClusterWideEnsureActivationTime(catalog);
                        this.clockService.waitFor(tsSafeForRoReadingInPastOptimization).whenComplete((ver, err1) -> {
                            if (err1 != null) {
                                error.addSuppressed((Throwable)err1);
                            }
                            resultFuture.completeExceptionally(error);
                        });
                    }
                } else {
                    resultFuture.completeExceptionally((Throwable)err);
                }
            } else {
                resultFuture.complete((Integer)newVersion);
            }
        });
        return resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Integer> saveUpdateEliminatingLocalConcurrency(UpdateProducer updateProducer) {
        Object object = this.lastSaveUpdateFutureMutex;
        synchronized (object) {
            CompletionStage chainedFuture = this.lastSaveUpdateFuture.thenCompose(unused -> this.saveUpdate(updateProducer, 0));
            this.lastSaveUpdateFuture = ((CompletableFuture)chainedFuture).handle((res, ex) -> null);
            return chainedFuture;
        }
    }

    private CompletableFuture<Integer> awaitVersionActivation(int version) {
        Catalog catalog = (Catalog)this.catalogByVer.get(version);
        HybridTimestamp tsSafeForRoReadingInPastOptimization = this.calcClusterWideEnsureActivationTime(catalog);
        return this.clockService.waitFor(tsSafeForRoReadingInPastOptimization).thenApply(unused -> version);
    }

    private HybridTimestamp calcClusterWideEnsureActivationTime(Catalog catalog) {
        return CatalogUtils.clusterWideEnsuredActivationTimestamp(catalog.time(), this.clockService.maxClockSkewMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CompletableFuture<Integer> saveUpdate(UpdateProducer updateProducer, int attemptNo) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            List<UpdateEntry> updates;
            if (attemptNo >= 10) {
                CompletableFuture<Integer> completableFuture = CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Max retry limit exceeded: " + attemptNo));
                return completableFuture;
            }
            Catalog catalog = this.catalogByVer.lastEntry().getValue();
            try {
                updates = updateProducer.get(catalog);
            }
            catch (CatalogValidationException ex) {
                CompletableFuture<Integer> completableFuture = CompletableFuture.failedFuture((Throwable)((Object)new CatalogVersionAwareValidationException((Throwable)((Object)ex), catalog.version())));
                this.busyLock.leaveBusy();
                return completableFuture;
            }
            catch (Exception ex) {
                CompletableFuture<Integer> completableFuture = CompletableFuture.failedFuture(ex);
                this.busyLock.leaveBusy();
                return completableFuture;
            }
            if (updates.isEmpty()) {
                CompletableFuture<Integer> ex = CompletableFuture.completedFuture(catalog.version());
                return ex;
            }
            int newVersion = catalog.version() + 1;
            CompletionStage completionStage = ((CompletableFuture)this.updateLog.append(new VersionedUpdate(newVersion, this.delayDurationMsSupplier.getAsLong(), updates)).thenCompose(result -> this.versionTracker.waitFor((Comparable)Integer.valueOf(newVersion)).thenApply(none -> result))).thenCompose(result -> {
                if (result.booleanValue()) {
                    return CompletableFuture.completedFuture(newVersion);
                }
                return this.saveUpdate(updateProducer, attemptNo + 1);
            });
            return completionStage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public List<SystemView<?>> systemViews() {
        return this.catalogSystemViewProvider.systemViews();
    }

    private static Catalog applyUpdateFinal(Catalog catalog, VersionedUpdate update, HybridTimestamp metaStorageUpdateTimestamp) {
        long activationTimestamp = metaStorageUpdateTimestamp.addPhysicalTime(update.delayDurationMs()).longValue();
        assert (activationTimestamp > catalog.time()) : "Activation timestamp " + activationTimestamp + " must be greater than previous catalog version activation timestamp " + catalog.time();
        return new Catalog(update.version(), activationTimestamp, catalog.objectIdGenState(), catalog.zones(), catalog.schemas(), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    class OnUpdateHandlerImpl
    implements UpdateLog.OnUpdateHandler {
        OnUpdateHandlerImpl() {
        }

        @Override
        public CompletableFuture<Void> handle(UpdateLogEvent event, HybridTimestamp metaStorageUpdateTimestamp, long causalityToken) {
            if (event instanceof SnapshotEntry) {
                return this.handle((SnapshotEntry)event);
            }
            return this.handle((VersionedUpdate)event, metaStorageUpdateTimestamp, causalityToken);
        }

        private CompletableFuture<Void> handle(SnapshotEntry event) {
            Catalog catalog = event.snapshot();
            CatalogManagerImpl.this.registerCatalog(catalog);
            CatalogManagerImpl.this.truncateUpTo(catalog);
            return CompletableFutures.nullCompletedFuture();
        }

        private CompletableFuture<Void> handle(VersionedUpdate update, HybridTimestamp metaStorageUpdateTimestamp, long causalityToken) {
            int version = update.version();
            Catalog catalog = (Catalog)CatalogManagerImpl.this.catalogByVer.get(version - 1);
            assert (catalog != null) : version - 1;
            for (UpdateEntry entry : update.entries()) {
                catalog = entry.applyUpdate(catalog, causalityToken);
            }
            catalog = CatalogManagerImpl.applyUpdateFinal(catalog, update, metaStorageUpdateTimestamp);
            CatalogManagerImpl.this.registerCatalog(catalog);
            ArrayList<CompletableFuture> eventFutures = new ArrayList<CompletableFuture>(update.entries().size());
            for (UpdateEntry entry : update.entries()) {
                if (!(entry instanceof Fireable)) continue;
                Fireable fireEvent = (Fireable)((Object)entry);
                eventFutures.add(CatalogManagerImpl.this.fireEvent(fireEvent.eventType(), (EventParameters)fireEvent.createEventParameters(causalityToken, version)));
            }
            return CompletableFuture.allOf((CompletableFuture[])eventFutures.toArray(CompletableFuture[]::new)).whenComplete((ignore, err) -> {
                if (err != null) {
                    LOG.warn("Failed to apply catalog update.", err);
                }
                CatalogManagerImpl.this.versionTracker.update((Comparable)Integer.valueOf(version), null);
            });
        }
    }

    private static class BulkUpdateProducer
    implements UpdateProducer {
        private final List<? extends UpdateProducer> commands;

        BulkUpdateProducer(List<? extends UpdateProducer> producers) {
            this.commands = producers;
        }

        @Override
        public List<UpdateEntry> get(Catalog catalog) {
            ArrayList<UpdateEntry> bulkUpdateEntries = new ArrayList<UpdateEntry>();
            for (UpdateProducer updateProducer : this.commands) {
                List<UpdateEntry> entries = updateProducer.get(catalog);
                for (UpdateEntry entry : entries) {
                    catalog = entry.applyUpdate(catalog, 0L);
                }
                bulkUpdateEntries.addAll(entries);
            }
            return bulkUpdateEntries;
        }
    }
}

