/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;

public abstract class AbstractTableCommand
implements CatalogCommand {
    protected final String schemaName;
    protected final String tableName;
    protected final boolean ifTableExists;

    AbstractTableCommand(String schemaName, String tableName, boolean ifTableExists) throws CatalogValidationException {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.ifTableExists = ifTableExists;
        this.validate();
    }

    public boolean ifTableExists() {
        return this.ifTableExists;
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.tableName, "Name of the table");
        CatalogParamsValidationUtils.ensureNonSystemSchemaUsed(this.schemaName);
    }
}

