/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogHashIndexDescriptor
extends CatalogIndexDescriptor {
    public static final CatalogObjectSerializer<CatalogHashIndexDescriptor> SERIALIZER = new HashIndexDescriptorSerializer();
    private final List<String> columns;

    public CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, List<String> columns) {
        this(id, name, tableId, unique, CatalogIndexStatus.REGISTERED, columns, 0L, false);
    }

    public CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<String> columns, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, columns, 0L, isCreatedWithTable);
    }

    private CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<String> columns, long causalityToken, boolean isCreatedWithTable) {
        super(CatalogIndexDescriptor.CatalogIndexDescriptorType.HASH, id, name, tableId, unique, status, causalityToken, isCreatedWithTable);
        this.columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
    }

    public List<String> columns() {
        return this.columns;
    }

    @Override
    public String toString() {
        return S.toString(CatalogHashIndexDescriptor.class, (Object)this, (String)super.toString());
    }

    private static class HashIndexDescriptorSerializer
    implements CatalogObjectSerializer<CatalogHashIndexDescriptor> {
        private HashIndexDescriptorSerializer() {
        }

        @Override
        public CatalogHashIndexDescriptor readFrom(IgniteDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateToken = input.readVarInt();
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            List columns = CatalogSerializationUtils.readStringCollection(input, ArrayList::new);
            return new CatalogHashIndexDescriptor(id, name, tableId, unique, status, columns, updateToken, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogHashIndexDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateToken());
            output.writeVarInt((long)descriptor.tableId());
            output.writeBoolean(descriptor.unique());
            output.writeByte(descriptor.status().id());
            output.writeBoolean(descriptor.isCreatedWithTable());
            CatalogSerializationUtils.writeStringCollection(descriptor.columns(), output);
        }
    }
}

