/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommand;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandSerializer;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FinishTxCommandImpl
implements FinishTxCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 40;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final List<TablePartitionIdMessage> partitionIds;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final UUID txId;

    private FinishTxCommandImpl(boolean commit, HybridTimestamp commitTimestamp, boolean full, HybridTimestamp initiatorTime, List<TablePartitionIdMessage> partitionIds, int requiredCatalogVersion, HybridTimestamp safeTime, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.partitionIds = partitionIds;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.safeTime = safeTime;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public List<TablePartitionIdMessage> partitionIds() {
        return this.partitionIds;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return FinishTxCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(FinishTxCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 40;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FinishTxCommandImpl otherMessage = (FinishTxCommandImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.partitionIds, otherMessage.partitionIds) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.full, this.requiredCatalogVersion, this.commitTimestamp, this.initiatorTime, this.partitionIds, this.safeTime, this.txId);
        return result;
    }

    public FinishTxCommandImpl clone() {
        try {
            return (FinishTxCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FinishTxCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitionIds != null) {
            for (TablePartitionIdMessage obj : this.partitionIds) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, (Object)marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitionIds != null) {
            for (TablePartitionIdMessage obj : this.partitionIds) {
                if (obj == null) continue;
                obj.unmarshal((Object)marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements FinishTxCommandBuilder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private boolean full;
        private HybridTimestamp initiatorTime;
        private List<TablePartitionIdMessage> partitionIds;
        private int requiredCatalogVersion;
        private HybridTimestamp safeTime;
        private UUID txId;

        private Builder() {
        }

        @Override
        public FinishTxCommandBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public FinishTxCommandBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public FinishTxCommandBuilder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public FinishTxCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public FinishTxCommandBuilder partitionIds(List<TablePartitionIdMessage> partitionIds) {
            Objects.requireNonNull(partitionIds, "partitionIds is not marked @Nullable");
            this.partitionIds = partitionIds;
            return this;
        }

        @Override
        public FinishTxCommandBuilder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public FinishTxCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public FinishTxCommandBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public List<TablePartitionIdMessage> partitionIds() {
            return this.partitionIds;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public FinishTxCommand build() {
            return new FinishTxCommandImpl(this.commit, this.commitTimestamp, this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.partitionIds, "partitionIds is not marked @Nullable"), this.requiredCatalogVersion, this.safeTime, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

