/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequestImpl;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ReadOnlyMultiRowPkReplicaRequestSerializer
implements MessageSerializer<ReadOnlyMultiRowPkReplicaRequest> {
    public static final ReadOnlyMultiRowPkReplicaRequestSerializer INSTANCE = new ReadOnlyMultiRowPkReplicaRequestSerializer();

    private ReadOnlyMultiRowPkReplicaRequestSerializer() {
    }

    public boolean writeMessage(ReadOnlyMultiRowPkReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadOnlyMultiRowPkReplicaRequestImpl message = (ReadOnlyMultiRowPkReplicaRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)8)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("coordinatorId", message.coordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("primaryKeys", message.primaryKeys(), MessageCollectionItemType.BYTE_BUFFER);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("readTimestamp", message.readTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                int ordinalShifted = message.requestType() == null ? 0 : message.requestType().ordinal() + 1;
                boolean written = writer.writeInt("requestType", ordinalShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeUuid("transactionId", message.transactionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

