/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.DirtyPagesAndPartitions;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.jetbrains.annotations.Nullable;

class CheckpointDirtyPages {
    static final Comparator<FullPageId> DIRTY_PAGE_COMPARATOR = Comparator.comparingInt(FullPageId::groupId).thenComparingLong(FullPageId::effectivePageId);
    static final CheckpointDirtyPages EMPTY = new CheckpointDirtyPages(List.of());
    private final List<DirtyPagesAndPartitions> dirtyPagesAndPartitions;
    private final int dirtyPagesCount;

    CheckpointDirtyPages(List<DirtyPagesAndPartitions> dirtyPagesAndPartitions) {
        assert (dirtyPagesAndPartitions instanceof RandomAccess) : dirtyPagesAndPartitions;
        this.dirtyPagesAndPartitions = dirtyPagesAndPartitions;
        this.dirtyPagesCount = dirtyPagesAndPartitions.stream().mapToInt(pages -> pages.dirtyPages.length).sum();
    }

    public int dirtyPagesCount() {
        return this.dirtyPagesCount;
    }

    public IgniteConcurrentMultiPairQueue<PersistentPageMemory, GroupPartitionId> toDirtyPartitionQueue() {
        List dirtyPartitions = this.dirtyPagesAndPartitions.stream().map(dirtyPagesAndPartitions -> new IgniteBiTuple((Object)dirtyPagesAndPartitions.pageMemory, (Object)((GroupPartitionId[])dirtyPagesAndPartitions.dirtyPartitions.toArray(GroupPartitionId[]::new)))).collect(Collectors.toList());
        return new IgniteConcurrentMultiPairQueue(dirtyPartitions);
    }

    @Nullable
    public CheckpointDirtyPagesView getPartitionView(PersistentPageMemory pageMemory, int grpId, int partId) {
        for (int i = 0; i < this.dirtyPagesAndPartitions.size(); ++i) {
            if (this.dirtyPagesAndPartitions.get((int)i).pageMemory != pageMemory) continue;
            return this.getPartitionView(i, grpId, partId);
        }
        throw new IllegalArgumentException("Unknown PageMemory: " + String.valueOf(pageMemory));
    }

    @Nullable
    private CheckpointDirtyPagesView getPartitionView(int dirtyPagesIdx, int grpId, int partId) {
        FullPageId startPageId = new FullPageId(PageIdUtils.pageId(partId, (byte)0, 0), grpId);
        FullPageId endPageId = new FullPageId(PageIdUtils.pageId(partId + 1, (byte)0, 0), grpId);
        FullPageId[] pageIds = this.dirtyPagesAndPartitions.get((int)dirtyPagesIdx).dirtyPages;
        int fromIndex = Arrays.binarySearch(pageIds, startPageId, DIRTY_PAGE_COMPARATOR);
        int n = fromIndex = fromIndex >= 0 ? fromIndex : Math.min(pageIds.length - 1, -fromIndex - 1);
        if (!CheckpointDirtyPages.equalsByGroupAndPartition(startPageId, pageIds[fromIndex])) {
            return null;
        }
        int toIndex = Arrays.binarySearch(pageIds, fromIndex, pageIds.length, endPageId, DIRTY_PAGE_COMPARATOR);
        toIndex = toIndex >= 0 ? toIndex : -toIndex - 1;
        return new CheckpointDirtyPagesView(dirtyPagesIdx, fromIndex, toIndex);
    }

    List<PersistentPageMemory> dirtyPageMemoryInstances() {
        return this.dirtyPagesAndPartitions.stream().map(p -> p.pageMemory).collect(Collectors.toList());
    }

    private static boolean equalsByGroupAndPartition(FullPageId pageId0, FullPageId pageId1) {
        return pageId0.groupId() == pageId1.groupId() && pageId0.partitionId() == pageId1.partitionId();
    }

    class CheckpointDirtyPagesView {
        private final int regionIndex;
        private final int fromPosition;
        private final int toPosition;

        private CheckpointDirtyPagesView(int regionIndex, int fromPosition, int toPosition) {
            this.regionIndex = regionIndex;
            this.fromPosition = fromPosition;
            this.toPosition = toPosition;
        }

        public FullPageId get(int index) {
            return CheckpointDirtyPages.this.dirtyPagesAndPartitions.get((int)this.regionIndex).dirtyPages[this.fromPosition + index];
        }

        public PersistentPageMemory pageMemory() {
            return CheckpointDirtyPages.this.dirtyPagesAndPartitions.get((int)this.regionIndex).pageMemory;
        }

        public int size() {
            return this.toPosition - this.fromPosition;
        }
    }
}

