/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.compaction;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionProcessingCounterMap;
import org.apache.ignite.internal.pagememory.persistence.WriteSpeedFormatter;
import org.apache.ignite.internal.pagememory.persistence.compaction.CompactionMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.pagememory.persistence.store.GroupPageStoresMap;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.internal.util.worker.IgniteWorkerListener;
import org.jetbrains.annotations.Nullable;

public class Compactor
extends IgniteWorker {
    private static final IgniteLogger LOG = Loggers.forClass(Compactor.class);
    private final Object mux = new Object();
    @Nullable
    private final ThreadPoolExecutor threadPoolExecutor;
    private boolean addedDeltaFiles;
    private final FilePageStoreManager filePageStoreManager;
    private static final ThreadLocal<ByteBuffer> THREAD_BUF = new ThreadLocal();
    private final PartitionProcessingCounterMap partitionCompactionInProgressMap = new PartitionProcessingCounterMap();
    private final int pageSize;
    private final FailureManager failureManager;

    public Compactor(IgniteLogger log, String igniteInstanceName, @Nullable IgniteWorkerListener listener, ConfigurationValue<Integer> threads, FilePageStoreManager filePageStoreManager, int pageSize, FailureManager failureManager) {
        super(log, igniteInstanceName, "compaction-thread", listener);
        this.filePageStoreManager = filePageStoreManager;
        this.failureManager = failureManager;
        int threadCount = (Integer)threads.value();
        this.threadPoolExecutor = threadCount > 1 ? new ThreadPoolExecutor(threadCount, threadCount, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("compaction-runner-io", log)) : null;
        this.pageSize = pageSize;
    }

    protected void body() throws InterruptedException {
        try {
            while (!this.isCancelled()) {
                this.waitDeltaFiles();
                if (this.isCancelled()) {
                    this.log.info("Skipping the delta file compaction because the node is stopping", new Object[0]);
                    return;
                }
                this.doCompaction();
            }
        }
        catch (Throwable t) {
            this.failureManager.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
            throw new IgniteInternalException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitDeltaFiles() {
        try {
            Object object = this.mux;
            synchronized (object) {
                while (!this.addedDeltaFiles && !this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        this.mux.wait();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
                this.addedDeltaFiles = false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.isCancelled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCompaction() {
        Object object = this.mux;
        synchronized (object) {
            this.addedDeltaFiles = true;
            this.mux.notifyAll();
        }
    }

    void doCompaction() {
        Queue queue;
        while (!(queue = (Queue)this.filePageStoreManager.allPageStores().map(groupPartitionFilePageStore -> {
            DeltaFilePageStoreIo deltaFileToCompaction = ((FilePageStore)groupPartitionFilePageStore.pageStore()).getDeltaFileToCompaction();
            if (deltaFileToCompaction == null) {
                return null;
            }
            return new DeltaFileForCompaction((GroupPageStoresMap.GroupPartitionPageStore<FilePageStore>)groupPartitionFilePageStore, deltaFileToCompaction);
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ConcurrentLinkedQueue::new))).isEmpty()) {
            String compactionId = UUID.randomUUID().toString();
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting new compaction round [compactionId={}, files={}]", new Object[]{compactionId, queue.size()});
            }
            CompactionMetricsTracker tracker = new CompactionMetricsTracker();
            this.updateHeartbeat();
            int threads = this.threadPoolExecutor == null ? 1 : this.threadPoolExecutor.getMaximumPoolSize();
            CompletableFuture[] futures = new CompletableFuture[threads];
            for (int i = 0; i < threads; ++i) {
                CompletableFuture future = futures[i] = new CompletableFuture();
                Runnable merger = () -> {
                    try {
                        DeltaFileForCompaction toMerge;
                        while ((toMerge = (DeltaFileForCompaction)queue.poll()) != null) {
                            GroupPartitionId groupPartitionId = toMerge.groupPartitionFilePageStore.groupPartitionId();
                            this.partitionCompactionInProgressMap.incrementPartitionProcessingCounter(groupPartitionId);
                            try {
                                this.mergeDeltaFileToMainFile(toMerge.groupPartitionFilePageStore.pageStore(), toMerge.deltaFilePageStoreIo, tracker);
                            }
                            finally {
                                this.partitionCompactionInProgressMap.decrementPartitionProcessingCounter(groupPartitionId);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    future.complete(null);
                };
                if (this.isCancelled()) {
                    return;
                }
                if (this.threadPoolExecutor == null) {
                    merger.run();
                    continue;
                }
                this.threadPoolExecutor.execute(merger);
            }
            this.updateHeartbeat();
            CompletableFuture.allOf(futures).join();
            tracker.onCompactionEnd();
            if (!LOG.isInfoEnabled()) continue;
            float totalDurationInSeconds = (float)tracker.totalDuration(TimeUnit.MILLISECONDS) / 1000.0f;
            float avgWriteSpeedInBytes = (float)((long)this.pageSize * (long)tracker.dataPagesWritten()) / totalDurationInSeconds;
            LOG.info("Compaction round finished [compactionId={}, pages={}, duration={}ms, avgWriteSpeed={}MB/s]", new Object[]{compactionId, tracker.dataPagesWritten(), tracker.totalDuration(TimeUnit.MILLISECONDS), WriteSpeedFormatter.formatWriteSpeed(avgWriteSpeedInBytes)});
        }
    }

    public void start() {
        if (this.runner() != null) {
            return;
        }
        assert (this.runner() == null) : "Compacter is running";
        new IgniteThread((IgniteWorker)this).start();
    }

    public void stop() throws Exception {
        this.cancel();
        boolean interrupt = false;
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                interrupt = true;
                continue;
            }
            break;
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
        if (this.threadPoolExecutor != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPoolExecutor, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + String.valueOf((Object)this), new Object[0]);
        }
        this.isCancelled.set(true);
        Object object = this.mux;
        synchronized (object) {
            this.mux.notifyAll();
        }
    }

    void mergeDeltaFileToMainFile(FilePageStore filePageStore, DeltaFilePageStoreIo deltaFilePageStore, CompactionMetricsTracker tracker) throws Throwable {
        ByteBuffer buffer = Compactor.getThreadLocalBuffer(this.pageSize);
        int[] nArray = deltaFilePageStore.pageIndexes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long pageIndex = nArray[i];
            this.updateHeartbeat();
            if (this.isCancelled()) {
                return;
            }
            if (filePageStore.isMarkedToDestroy()) {
                return;
            }
            long pageOffset = deltaFilePageStore.pageOffset(pageIndex);
            boolean read = deltaFilePageStore.readWithMergedToFilePageStoreCheck(pageIndex, pageOffset, buffer.rewind(), false);
            assert (read) : deltaFilePageStore.filePath();
            long pageId = PageIo.getPageId(buffer.rewind());
            assert (pageId != 0L) : deltaFilePageStore.filePath();
            this.updateHeartbeat();
            if (this.isCancelled()) {
                return;
            }
            if (filePageStore.isMarkedToDestroy()) {
                return;
            }
            filePageStore.write(pageId, buffer.rewind(), true);
            tracker.onDataPageWritten();
        }
        this.updateHeartbeat();
        if (this.isCancelled()) {
            return;
        }
        if (filePageStore.isMarkedToDestroy()) {
            return;
        }
        filePageStore.sync();
        this.updateHeartbeat();
        if (this.isCancelled()) {
            return;
        }
        if (filePageStore.isMarkedToDestroy()) {
            return;
        }
        deltaFilePageStore.markMergedToFilePageStore();
        deltaFilePageStore.stop(true);
        boolean removed = filePageStore.removeDeltaFile(deltaFilePageStore);
        assert (removed) : filePageStore.filePath();
    }

    public CompletableFuture<Void> prepareToDestroyPartition(GroupPartitionId groupPartitionId) {
        CompletableFuture<Void> partitionProcessingFuture = this.partitionCompactionInProgressMap.getProcessedPartitionFuture(groupPartitionId);
        return partitionProcessingFuture == null ? CompletableFutures.nullCompletedFuture() : partitionProcessingFuture;
    }

    private static ByteBuffer getThreadLocalBuffer(int pageSize) {
        ByteBuffer buffer = THREAD_BUF.get();
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(pageSize);
            buffer.order(ByteOrder.nativeOrder());
            THREAD_BUF.set(buffer);
        }
        return buffer;
    }

    private static class DeltaFileForCompaction {
        private final GroupPageStoresMap.GroupPartitionPageStore<FilePageStore> groupPartitionFilePageStore;
        private final DeltaFilePageStoreIo deltaFilePageStoreIo;

        private DeltaFileForCompaction(GroupPageStoresMap.GroupPartitionPageStore<FilePageStore> groupPartitionFilePageStore, DeltaFilePageStoreIo deltaFilePageStoreIo) {
            this.groupPartitionFilePageStore = groupPartitionFilePageStore;
            this.deltaFilePageStoreIo = deltaFilePageStoreIo;
        }
    }
}

