/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class AntiHijackJobExecution<R>
implements JobExecution<R> {
    private final JobExecution<R> execution;
    private final Executor asyncContinuationExecutor;

    public AntiHijackJobExecution(JobExecution<R> execution, Executor asyncContinuationExecutor) {
        this.execution = execution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public CompletableFuture<R> resultAsync() {
        return this.preventThreadHijack(this.execution.resultAsync());
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.preventThreadHijack(this.execution.stateAsync());
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.preventThreadHijack(this.execution.changePriorityAsync(newPriority));
    }

    public ClusterNode node() {
        return this.execution.node();
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, (Executor)this.asyncContinuationExecutor);
    }
}

