/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

class TaskExecutionWrapper<R>
implements TaskExecution<R>,
MarshallerProvider<R> {
    private final TaskExecution<R> delegate;

    TaskExecutionWrapper(TaskExecution<R> delegate) {
        this.delegate = delegate;
    }

    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.statesAsync());
    }

    public CompletableFuture<R> resultAsync() {
        return ComputeUtils.convertToComputeFuture(this.delegate.resultAsync());
    }

    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.stateAsync());
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.changePriorityAsync(newPriority));
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        if (this.delegate instanceof MarshallerProvider) {
            return ((MarshallerProvider)this.delegate).resultMarshaller();
        }
        return null;
    }

    @Override
    public boolean marshalResult() {
        return this.delegate instanceof MarshallerProvider && ((MarshallerProvider)this.delegate).marshalResult();
    }
}

