/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.messaging;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.messaging.ComputeMessaging;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class RemoteJobExecution<R>
implements CancellableJobExecution<R> {
    private final ClusterNode remoteNode;
    private final CompletableFuture<UUID> jobIdFuture;
    private final CompletableFuture<R> resultFuture;
    private final InFlightFutures inFlightFutures;
    private final ComputeMessaging messaging;

    public RemoteJobExecution(ClusterNode remoteNode, CompletableFuture<UUID> jobIdFuture, CompletableFuture<R> resultFuture, InFlightFutures inFlightFutures, ComputeMessaging messaging) {
        this.remoteNode = remoteNode;
        this.jobIdFuture = jobIdFuture;
        this.resultFuture = resultFuture;
        this.inFlightFutures = inFlightFutures;
        this.messaging = messaging;
    }

    public CompletableFuture<R> resultAsync() {
        return this.resultFuture;
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.inFlightFutures.registerFuture((CompletableFuture)this.jobIdFuture.thenCompose(jobId -> this.messaging.remoteStateAsync(this.remoteNode, (UUID)jobId)));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.inFlightFutures.registerFuture((CompletableFuture)this.jobIdFuture.thenCompose(jobId -> this.messaging.remoteCancelAsync(this.remoteNode, (UUID)jobId)));
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.inFlightFutures.registerFuture((CompletableFuture)this.jobIdFuture.thenCompose(jobId -> this.messaging.remoteChangePriorityAsync(this.remoteNode, (UUID)jobId, newPriority)));
    }

    public ClusterNode node() {
        return this.remoteNode;
    }
}

