/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.task;

import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.JobStatus;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.compute.TaskStatus;
import org.apache.ignite.compute.task.MapReduceJob;
import org.apache.ignite.compute.task.MapReduceTask;
import org.apache.ignite.compute.task.TaskExecutionContext;
import org.apache.ignite.internal.compute.CancellableTaskExecution;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.compute.TaskStateImpl;
import org.apache.ignite.internal.compute.queue.PriorityQueueExecutor;
import org.apache.ignite.internal.compute.queue.QueueExecution;
import org.apache.ignite.internal.compute.task.JobSubmitter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

public class TaskExecutionInternal<I, M, T, R>
implements CancellableTaskExecution<R>,
MarshallerProvider<R> {
    private static final IgniteLogger LOG = Loggers.forClass(TaskExecutionInternal.class);
    private final QueueExecution<SplitResult<I, M, T, R>> splitExecution;
    private final CompletableFuture<List<JobExecution<T>>> executionsFuture;
    private final CompletableFuture<Map<UUID, T>> resultsFuture;
    private final CompletableFuture<QueueExecution<R>> reduceExecutionFuture;
    private final AtomicReference<TaskState> reduceFailedState = new AtomicReference();
    private final CancelHandle cancelHandle = CancelHandle.create();
    private final AtomicBoolean isCancelled;
    @Nullable
    private volatile Marshaller<R, byte[]> reduceResultMarshallerRef;

    public TaskExecutionInternal(PriorityQueueExecutor executorService, JobSubmitter<M, T> jobSubmitter, Class<? extends MapReduceTask<I, M, T, R>> taskClass, TaskExecutionContext context, AtomicBoolean isCancelled, I arg) {
        this.isCancelled = isCancelled;
        LOG.debug("Executing task {}", new Object[]{taskClass.getName()});
        this.splitExecution = executorService.submit(() -> {
            MapReduceTask task = ComputeUtils.instantiateTask(taskClass);
            this.reduceResultMarshallerRef = task.reduceJobResultMarshaller();
            Class<?> splitArgumentType = ComputeUtils.getTaskSplitArgumentType(taskClass);
            return task.splitAsync(context, ComputeUtils.unmarshalOrNotIfNull(task.splitJobInputMarshaller(), arg, splitArgumentType)).thenApply(jobs -> new SplitResult(task, jobs));
        }, Integer.MAX_VALUE, 0);
        this.executionsFuture = this.splitExecution.resultAsync().thenCompose(splitResult -> {
            List runners = splitResult.runners();
            LOG.debug("Submitting {} jobs for {}", new Object[]{runners.size(), taskClass.getName()});
            return jobSubmitter.submit(runners, this.cancelHandle.token());
        });
        this.resultsFuture = this.executionsFuture.thenCompose(TaskExecutionInternal::resultsAsync);
        this.reduceExecutionFuture = ((CompletableFuture)this.resultsFuture.thenApply(results -> {
            LOG.debug("Running reduce job for {}", new Object[]{taskClass.getName()});
            MapReduceTask task = (MapReduceTask)((CompletableFuture)this.splitExecution.resultAsync().thenApply(rec$ -> ((SplitResult)rec$).task())).join();
            return executorService.submit(() -> task.reduceAsync(context, results), Integer.MAX_VALUE, 0);
        })).whenComplete(this::captureReduceFailure);
    }

    private void captureReduceFailure(QueueExecution<R> reduceExecution, Throwable throwable) {
        if (throwable != null) {
            TaskStatus status = throwable instanceof CancellationException ? TaskStatus.CANCELED : TaskStatus.FAILED;
            JobState state = this.splitExecution.state();
            if (state != null) {
                this.reduceFailedState.set((TaskState)TaskStateImpl.toBuilder((JobState)state).status(status).finishTime(Instant.now()).build());
            }
        }
    }

    public CompletableFuture<R> resultAsync() {
        return this.reduceExecutionFuture.thenCompose(QueueExecution::resultAsync);
    }

    public CompletableFuture<@Nullable TaskState> stateAsync() {
        JobState splitState = this.splitExecution.state();
        if (splitState == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (splitState.status() != JobStatus.COMPLETED) {
            return CompletableFuture.completedFuture(TaskStateImpl.toBuilder((JobState)splitState).build());
        }
        if (this.reduceExecutionFuture.isDone()) {
            return this.reduceExecutionFuture.handle((reduceExecution, throwable) -> {
                if (throwable == null) {
                    JobState reduceState = reduceExecution.state();
                    if (reduceState == null) {
                        return null;
                    }
                    return TaskStateImpl.toBuilder((JobState)reduceState).id(splitState.id()).createTime(splitState.createTime()).startTime(splitState.startTime()).build();
                }
                return this.reduceFailedState.get();
            });
        }
        return CompletableFuture.completedFuture(TaskStateImpl.toBuilder((JobState)splitState).status(TaskStatus.EXECUTING).finishTime(null).build());
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        if (!this.isCancelled.compareAndSet(false, true)) {
            return CompletableFutures.falseCompletedFuture();
        }
        if (this.splitExecution.cancel()) {
            this.executionsFuture.cancel(true);
            return CompletableFutures.trueCompletedFuture();
        }
        if (this.executionsFuture.cancel(true)) {
            return CompletableFutures.trueCompletedFuture();
        }
        if (this.resultsFuture.cancel(true)) {
            return ((CompletableFuture)this.executionsFuture.thenCompose(unused -> this.cancelHandle.cancelAsync())).thenApply(unused -> true);
        }
        if (this.reduceExecutionFuture.cancel(true)) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.reduceExecutionFuture.thenApply(QueueExecution::cancel);
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        if (this.splitExecution.changePriority(newPriority)) {
            return CompletableFutures.trueCompletedFuture();
        }
        if (this.reduceExecutionFuture.isDone()) {
            return this.reduceExecutionFuture.thenApply(reduceExecution -> reduceExecution.changePriority(newPriority));
        }
        return this.executionsFuture.thenCompose(executions -> {
            CompletableFuture[] changePriorityFutures = (CompletableFuture[])executions.stream().map(execution -> execution.changePriorityAsync(newPriority)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(changePriorityFutures).thenApply(unused -> {
                List<@Nullable T> results = Arrays.stream(changePriorityFutures).map(CompletableFuture::join).collect(Collectors.toList());
                if (results.stream().allMatch(b -> b == Boolean.TRUE)) {
                    return true;
                }
                if (results.stream().anyMatch(Objects::isNull)) {
                    return null;
                }
                return false;
            });
        });
    }

    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return this.executionsFuture.thenCompose(executions -> {
            CompletableFuture[] stateFutures = (CompletableFuture[])executions.stream().map(JobExecution::stateAsync).toArray(CompletableFuture[]::new);
            return CompletableFutures.allOfToList((CompletableFuture[])stateFutures);
        });
    }

    private static <T> CompletableFuture<Map<UUID, T>> resultsAsync(List<JobExecution<T>> executions) {
        Object[] resultFutures = (CompletableFuture[])executions.stream().map(JobExecution::resultAsync).toArray(CompletableFuture[]::new);
        Object[] idFutures = (CompletableFuture[])executions.stream().map(JobExecution::idAsync).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf((CompletableFuture[])ArrayUtils.concat((Object[])resultFutures, (Object[])idFutures)).thenApply(arg_0 -> TaskExecutionInternal.lambda$resultsAsync$19((CompletableFuture[])resultFutures, (CompletableFuture[])idFutures, arg_0));
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        return this.reduceResultMarshallerRef;
    }

    @Override
    public boolean marshalResult() {
        return false;
    }

    private static /* synthetic */ Map lambda$resultsAsync$19(CompletableFuture[] resultFutures, CompletableFuture[] idFutures, Void unused) {
        LinkedHashMap results = new LinkedHashMap();
        for (int i = 0; i < resultFutures.length; ++i) {
            results.put((UUID)idFutures[i].join(), resultFutures[i].join());
        }
        return results;
    }

    private static class SplitResult<I, M, T, R> {
        private final MapReduceTask<I, M, T, R> task;
        private final List<MapReduceJob<M, T>> runners;

        private SplitResult(MapReduceTask<I, M, T, R> task, List<MapReduceJob<M, T>> runners) {
            this.task = task;
            this.runners = runners;
        }

        private List<MapReduceJob<M, T>> runners() {
            return this.runners;
        }

        private MapReduceTask<I, M, T, R> task() {
            return this.task;
        }
    }
}

