/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.function.BiFunction;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.jetbrains.annotations.Nullable;

public class InternalSqlRowImpl<RowT>
implements InternalSqlRow {
    private final RowT row;
    private final RowHandler<RowT> rowHandler;
    private final BiFunction<Integer, Object, Object> internalTypeConverter;

    public InternalSqlRowImpl(RowT row, RowHandler<RowT> rowHandler, BiFunction<Integer, Object, Object> internalTypeConverter) {
        this.row = row;
        this.rowHandler = rowHandler;
        this.internalTypeConverter = internalTypeConverter;
    }

    @Override
    @Nullable
    public Object get(int idx) {
        Object res = this.rowHandler.get(idx, this.row);
        return this.internalTypeConverter.apply(idx, res);
    }

    @Override
    public int fieldCount() {
        return this.rowHandler.columnCount(this.row);
    }

    @Override
    public BinaryTuple asBinaryTuple() {
        return this.rowHandler.toBinaryTuple(this.row);
    }
}

