/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.time.ZoneId;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesHelper;
import org.jetbrains.annotations.Nullable;

public final class QueryProperty {
    public static final Property<Long> QUERY_TIMEOUT = new Property<Long>("query_timeout", Long.class);
    public static final Property<Set<SqlQueryType>> ALLOWED_QUERY_TYPES = new Property("allowed_query_types", (Class)QueryProperty.cast(Set.class));
    public static final Property<String> DEFAULT_SCHEMA = new Property<String>("default_schema", String.class);
    public static final Property<ZoneId> TIME_ZONE_ID = new Property<ZoneId>("time_zone_id", ZoneId.class);
    private static final Map<String, Property<?>> propsByName = SqlPropertiesHelper.createPropsByNameMap(QueryProperty.class);

    @Nullable
    public static Property<?> byName(String name) {
        return propsByName.get(name);
    }

    private static <T> T cast(Class<?> anyClass) {
        return (T)anyClass;
    }
}

