/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite.internal.sql.engine.exec.rel.StorageScanNode;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.apache.ignite.internal.util.TransformingIterator;
import org.jetbrains.annotations.Nullable;

public class IndexScanNode<RowT>
extends StorageScanNode<RowT> {
    private final IgniteIndex schemaIndex;
    private final ScannableTable table;
    private final RowHandler.RowFactory<RowT> factory;
    private final PartitionProvider<RowT> partitionProvider;
    @Nullable
    private final BitSet requiredColumns;
    @Nullable
    private final RangeIterable<RowT> rangeConditions;
    @Nullable
    private final Comparator<RowT> comp;
    private final List<String> columns;

    public IndexScanNode(ExecutionContext<RowT> ctx, RowHandler.RowFactory<RowT> rowFactory, IgniteIndex schemaIndex, ScannableTable table, TableDescriptor tableDescriptor, PartitionProvider<RowT> partitionProvider, @Nullable Comparator<RowT> comp, @Nullable RangeIterable<RowT> rangeConditions, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer, @Nullable BitSet requiredColumns) {
        super(ctx, filters, rowTransformer);
        this.schemaIndex = schemaIndex;
        this.table = table;
        this.partitionProvider = partitionProvider;
        this.requiredColumns = requiredColumns;
        this.rangeConditions = rangeConditions;
        this.comp = comp;
        this.factory = rowFactory;
        this.columns = schemaIndex.collation().getFieldCollations().stream().map(RelFieldCollation::getFieldIndex).map(tableDescriptor::columnDescriptor).map(ColumnDescriptor::name).collect(Collectors.toList());
    }

    @Override
    protected Flow.Publisher<RowT> scan() {
        List<PartitionWithConsistencyToken> partitions = this.partitionProvider.getPartitions(this.context());
        if (this.rangeConditions != null) {
            return SubscriptionUtils.concat((Iterator)new TransformingIterator(this.rangeConditions.iterator(), cond -> this.indexPublisher((Collection<PartitionWithConsistencyToken>)partitions, (RangeCondition<RowT>)cond)));
        }
        return this.indexPublisher(partitions, null);
    }

    private Flow.Publisher<RowT> indexPublisher(Collection<PartitionWithConsistencyToken> partsWithConsistencyTokens, @Nullable RangeCondition<RowT> cond) {
        TransformingIterator it = new TransformingIterator(partsWithConsistencyTokens.iterator(), partWithConsistencyToken -> this.partitionPublisher((PartitionWithConsistencyToken)partWithConsistencyToken, cond));
        if (this.comp != null) {
            return SubscriptionUtils.orderedMerge(this.comp, (int)100, (Iterator)it);
        }
        return SubscriptionUtils.concat((Iterator)it);
    }

    private Flow.Publisher<RowT> partitionPublisher(PartitionWithConsistencyToken partWithConsistencyToken, @Nullable RangeCondition<RowT> cond) {
        int indexId = this.schemaIndex.id();
        ExecutionContext ctx = this.context();
        switch (this.schemaIndex.type()) {
            case SORTED: {
                return this.table.indexRangeScan(ctx, partWithConsistencyToken, this.factory, indexId, this.columns, cond, this.requiredColumns);
            }
            case HASH: {
                return this.table.indexLookup(ctx, partWithConsistencyToken, this.factory, indexId, this.columns, cond.lower(), this.requiredColumns);
            }
        }
        throw new AssertionError((Object)("Unexpected index type: " + String.valueOf((Object)this.schemaIndex.type())));
    }
}

