/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponse;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponseBuilder;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponseSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryStartResponseImpl
implements QueryStartResponse,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private Throwable error;
    private byte[] errorByteArray;
    @IgniteToStringInclude
    private final int executionToken;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final UUID queryId;

    private QueryStartResponseImpl(Throwable error, byte[] errorByteArray, int executionToken, long fragmentId, UUID queryId) {
        this.error = error;
        this.errorByteArray = errorByteArray;
        this.executionToken = executionToken;
        this.fragmentId = fragmentId;
        this.queryId = queryId;
    }

    byte[] errorByteArray() {
        return this.errorByteArray;
    }

    @Override
    public Throwable error() {
        return this.error;
    }

    @Override
    public int executionToken() {
        return this.executionToken;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public MessageSerializer serializer() {
        return QueryStartResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryStartResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryStartResponseImpl otherMessage = (QueryStartResponseImpl)other;
        return Objects.equals(this.error, otherMessage.error) && Objects.equals(this.queryId, otherMessage.queryId) && this.executionToken == otherMessage.executionToken && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.executionToken, this.fragmentId, this.error, this.queryId);
        return result;
    }

    public QueryStartResponseImpl clone() {
        try {
            return (QueryStartResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QueryStartResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject errorByteArraymo = marshaller.marshal((Object)this.error);
        usedDescriptors.addAll((IntCollection)errorByteArraymo.usedDescriptorIds());
        this.errorByteArray = errorByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.error = (Throwable)marshaller.unmarshal(this.errorByteArray, descriptorsObj);
        this.errorByteArray = null;
    }

    private static class Builder
    implements QueryStartResponseBuilder {
        private Throwable error;
        private byte[] errorByteArray;
        private int executionToken;
        private long fragmentId;
        private UUID queryId;

        private Builder() {
        }

        @Override
        public QueryStartResponseBuilder error(Throwable error) {
            this.error = error;
            return this;
        }

        @Override
        public QueryStartResponseBuilder errorByteArray(byte[] errorByteArray) {
            this.errorByteArray = errorByteArray;
            return this;
        }

        @Override
        public QueryStartResponseBuilder executionToken(int executionToken) {
            this.executionToken = executionToken;
            return this;
        }

        @Override
        public QueryStartResponseBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryStartResponseBuilder queryId(UUID queryId) {
            Objects.requireNonNull(queryId, "queryId is not marked @Nullable");
            this.queryId = queryId;
            return this;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public byte[] errorByteArray() {
            return this.errorByteArray;
        }

        @Override
        public int executionToken() {
            return this.executionToken;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public QueryStartResponse build() {
            return new QueryStartResponseImpl(this.error, this.errorByteArray, this.executionToken, this.fragmentId, Objects.requireNonNull(this.queryId, "queryId is not marked @Nullable"));
        }
    }
}

