/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import org.jetbrains.annotations.Nullable;

public final class IgniteSqlValidatorErrorMessages {
    private IgniteSqlValidatorErrorMessages() {
    }

    @Nullable
    public static String resolveErrorMessage(@Nullable String message) {
        if (message == null) {
            return null;
        }
        for (Overrides override : Overrides.values()) {
            if (!override.test(message)) continue;
            return override.replace(message);
        }
        return null;
    }

    static enum Overrides {
        COLUMN_NOT_NULLABLE("has no default value and does not allow NULLs", "does not allow NULLs"),
        NATURAL_OR_USING_COLUMN_NOT_COMPATIBLE("matched using NATURAL keyword or USING clause has incompatible types: cannot compare", "matched using NATURAL keyword or USING clause has incompatible types in this context:");

        private final String toReplace;
        private final String replacement;

        private Overrides(String toReplace, String replacement) {
            this.toReplace = toReplace;
            this.replacement = replacement;
        }

        boolean test(String originalMessage) {
            return originalMessage.contains(this.toReplace);
        }

        String replace(String originalMessage) {
            return originalMessage.replace(this.toReplace, this.replacement);
        }
    }
}

