/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.InternalSqlRowImpl;
import org.apache.ignite.internal.sql.engine.QueryPrefetchCallback;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlPredicate;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.AsyncWrapper;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class KeyValueGetPlan
implements ExplainablePlan,
ExecutablePlan {
    private static final IgniteLogger LOG = Loggers.forClass(KeyValueGetPlan.class);
    private final PlanId id;
    private final int catalogVersion;
    private final IgniteKeyValueGet lookupNode;
    private final ResultSetMetadata meta;
    private final ParameterMetadata parameterMetadata;
    private volatile Performable<?> operation;

    KeyValueGetPlan(PlanId id, int catalogVersion, IgniteKeyValueGet lookupNode, ResultSetMetadata meta, ParameterMetadata parameterMetadata) {
        this.id = id;
        this.catalogVersion = catalogVersion;
        this.lookupNode = lookupNode;
        this.meta = meta;
        this.parameterMetadata = parameterMetadata;
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public SqlQueryType type() {
        return SqlQueryType.QUERY;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    private IgniteTable table() {
        IgniteTable table = (IgniteTable)this.lookupNode.getTable().unwrap(IgniteTable.class);
        assert (table != null) : this.lookupNode.getTable();
        return table;
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.lookupNode, Commons.cluster());
        return RelOptUtil.toString((RelNode)clonedRoot, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
    }

    public IgniteKeyValueGet lookupNode() {
        return this.lookupNode;
    }

    private <RowT> Performable<RowT> operation(ExecutionContext<RowT> ctx, ExecutableTableRegistry tableRegistry) {
        Performable operation = (Performable)Commons.cast(this.operation);
        if (operation != null) {
            return operation;
        }
        IgniteTable sqlTable = this.table();
        ExecutableTable executableTable = tableRegistry.getTable(this.catalogVersion, sqlTable.id());
        ScannableTable scannableTable = executableTable.scannableTable();
        ImmutableBitSet requiredColumns = this.lookupNode.requiredColumns();
        RexNode filterExpr = this.lookupNode.condition();
        List<RexNode> projectionExpr = this.lookupNode.projects();
        RelDataType rowType = sqlTable.getRowType((RelDataTypeFactory)Commons.typeFactory(), requiredColumns);
        SqlPredicate<RowT> filter = filterExpr == null ? null : ctx.expressionFactory().predicate(filterExpr, rowType);
        SqlProjection<RowT> projection = projectionExpr == null ? null : ctx.expressionFactory().project(projectionExpr, rowType);
        RowHandler<RowT> rowHandler = ctx.rowHandler();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = rowHandler.factory(rowSchema);
        List<RexNode> keyExpressions = this.lookupNode.keyExpressions();
        SqlRowProvider<RowT> keySupplier = ctx.expressionFactory().rowSource(keyExpressions);
        RelDataType resultType = this.lookupNode.getRowType();
        BiFunction<Integer, Object, Object> internalTypeConverter = TypeUtils.resultTypeConverter(ctx, resultType);
        operation = filter == null && projection == null ? new SimpleLookupExecution<RowT>(scannableTable, rowHandler, rowFactory, keySupplier, requiredColumns.toBitSet(), internalTypeConverter) : new FilterableProjectableLookupExecution<RowT>(scannableTable, rowHandler, rowFactory, keySupplier, filter, projection, requiredColumns.toBitSet(), internalTypeConverter);
        this.operation = operation;
        return operation;
    }

    @Override
    public <RowT> AsyncCursor<InternalSqlRow> execute(ExecutionContext<RowT> ctx, InternalTransaction tx, ExecutableTableRegistry tableRegistry, @Nullable QueryPrefetchCallback firstPageReadyCallback) {
        Performable<RowT> operation = this.operation(ctx, tableRegistry);
        CompletableFuture<Iterator<InternalSqlRow>> result = operation.perform(ctx, tx);
        if (firstPageReadyCallback != null) {
            result.whenComplete((res, err) -> firstPageReadyCallback.onPrefetchComplete((Throwable)err));
        }
        ctx.scheduleTimeout(result);
        return new AsyncWrapper(result, Runnable::run);
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    private static abstract class Performable<RowT> {
        private Performable() {
        }

        abstract CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> var1, @Nullable InternalTransaction var2);
    }

    private static class SimpleLookupExecution<RowT>
    extends Performable<RowT> {
        private final ScannableTable table;
        private final RowHandler<RowT> rowHandler;
        private final RowHandler.RowFactory<RowT> tableRowFactory;
        private final SqlRowProvider<RowT> keySupplier;
        private final BitSet requiredColumns;
        private final BiFunction<Integer, Object, Object> internalTypeConverter;

        private SimpleLookupExecution(ScannableTable table, RowHandler<RowT> rowHandler, RowHandler.RowFactory<RowT> tableRowFactory, SqlRowProvider<RowT> keySupplier, BitSet requiredColumns, BiFunction<Integer, Object, Object> internalTypeConverter) {
            this.table = table;
            this.rowHandler = rowHandler;
            this.tableRowFactory = tableRowFactory;
            this.keySupplier = keySupplier;
            this.requiredColumns = requiredColumns;
            this.internalTypeConverter = internalTypeConverter;
        }

        @Override
        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            Object key = this.keySupplier.get(ctx);
            return this.table.primaryKeyLookup(ctx, tx, this.tableRowFactory, key, this.requiredColumns).thenApply(row -> {
                if (row == null) {
                    return Collections.emptyIterator();
                }
                return List.of(new InternalSqlRowImpl<Object>(row, this.rowHandler, this.internalTypeConverter)).iterator();
            });
        }
    }

    private static class FilterableProjectableLookupExecution<RowT>
    extends Performable<RowT> {
        private final ScannableTable table;
        private final RowHandler<RowT> rowHandler;
        private final RowHandler.RowFactory<RowT> tableRowFactory;
        private final SqlRowProvider<RowT> keySupplier;
        @Nullable
        private final SqlPredicate<RowT> filter;
        @Nullable
        private final SqlProjection<RowT> projection;
        @Nullable
        private final BitSet requiredColumns;
        private final BiFunction<Integer, Object, Object> internalTypeConverter;

        private FilterableProjectableLookupExecution(ScannableTable table, RowHandler<RowT> rowHandler, RowHandler.RowFactory<RowT> tableRowFactory, SqlRowProvider<RowT> keySupplier, @Nullable SqlPredicate<RowT> filter, @Nullable SqlProjection<RowT> projection, @Nullable BitSet requiredColumns, BiFunction<Integer, Object, Object> internalTypeConverter) {
            this.table = table;
            this.rowHandler = rowHandler;
            this.tableRowFactory = tableRowFactory;
            this.keySupplier = keySupplier;
            this.filter = filter;
            this.projection = projection;
            this.requiredColumns = requiredColumns;
            this.internalTypeConverter = internalTypeConverter;
        }

        @Override
        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            Executor executor = task -> ctx.execute(task::run, error -> LOG.error("Unexpected error", error));
            Object key = this.keySupplier.get(ctx);
            return this.table.primaryKeyLookup(ctx, tx, this.tableRowFactory, key, this.requiredColumns).thenApplyAsync(row -> {
                if (row == null) {
                    return Collections.emptyIterator();
                }
                if (this.filter != null && !this.filter.test(ctx, row)) {
                    return Collections.emptyIterator();
                }
                if (this.projection != null) {
                    row = this.projection.project(ctx, row);
                }
                return List.of(new InternalSqlRowImpl<Object>(row, this.rowHandler, this.internalTypeConverter)).iterator();
            }, executor);
        }
    }
}

