/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.pruning;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.prepare.pruning.ModifyNodeVisitor;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PartitionPruningMetadataExtractor
extends IgniteRelShuttle {
    private final Long2ObjectMap<PartitionPruningColumns> result = new Long2ObjectOpenHashMap();

    public PartitionPruningMetadata go(IgniteRel rel) {
        this.result.clear();
        rel.accept(this);
        if (this.result.isEmpty()) {
            return PartitionPruningMetadata.EMPTY;
        }
        return new PartitionPruningMetadata((Long2ObjectMap<PartitionPruningColumns>)new Long2ObjectOpenHashMap(this.result));
    }

    @Override
    public IgniteRel visit(IgniteIndexScan rel) {
        RexNode condition = rel.condition();
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null) : "No table";
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        this.extractFromTable(rel.sourceId(), table, rel.requiredColumns(), condition, rexBuilder);
        return super.visit(rel);
    }

    @Override
    public IgniteRel visit(IgniteTableScan rel) {
        RexNode condition = rel.condition();
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null) : "No table";
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        this.extractFromTable(rel.sourceId(), table, rel.requiredColumns(), condition, rexBuilder);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteTableModify rel) {
        if (rel.getOperation() != TableModify.Operation.INSERT) {
            return super.visit(rel);
        }
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        List<List<RexNode>> results = ModifyNodeVisitor.go(rel);
        if (results == null) {
            return rel;
        }
        this.extractFromValues(rel.sourceId(), table, results, rexBuilder);
        return super.visit(rel);
    }

    private void extractFromValues(long sourceId, IgniteTable table, List<List<RexNode>> expressions, RexBuilder rexBuilder) {
        RexNode call;
        PartitionPruningColumns metadata;
        IntList keysList = PartitionPruningMetadataExtractor.distributionKeys(table);
        if (keysList.isEmpty()) {
            return;
        }
        ArrayList<RexNode> andEqNodes = new ArrayList<RexNode>();
        RelDataType rowTypes = table.getRowType((RelDataTypeFactory)Commons.typeFactory());
        for (List<RexNode> items : expressions) {
            ArrayList<RexNode> andNodes = new ArrayList<RexNode>(keysList.size());
            IntListIterator intListIterator = keysList.iterator();
            while (intListIterator.hasNext()) {
                int key = (Integer)intListIterator.next();
                RexLocalRef ref = rexBuilder.makeLocalRef(((RelDataTypeField)rowTypes.getFieldList().get(key)).getType(), key);
                RexNode lit = items.get(key);
                if (!PartitionPruningMetadataExtractor.isValueExpr(lit)) {
                    return;
                }
                RexNode eq = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{ref, lit});
                andNodes.add(eq);
            }
            if (andNodes.size() > 1) {
                RexNode node0 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, andNodes);
                andEqNodes.add(node0);
                continue;
            }
            andEqNodes.add((RexNode)andNodes.get(0));
        }
        if (!CollectionUtils.nullOrEmpty(andEqNodes) && (metadata = PartitionPruningMetadataExtractor.extractMetadata(keysList, call = andEqNodes.size() > 1 ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, andEqNodes) : (RexNode)andEqNodes.get(0), rexBuilder)) != null) {
            this.result.put(sourceId, (Object)metadata);
        }
    }

    private void extractFromTable(long sourceId, IgniteTable table, @Nullable ImmutableBitSet requiredColumns, @Nullable RexNode condition, RexBuilder rexBuilder) {
        RexNode remappedCondition;
        if (condition == null) {
            return;
        }
        IntList keysList = PartitionPruningMetadataExtractor.distributionKeys(table);
        PartitionPruningColumns metadata = PartitionPruningMetadataExtractor.extractMetadata(keysList, remappedCondition = requiredColumns != null ? PartitionPruningMetadataExtractor.remapColumns(table, requiredColumns, condition, rexBuilder) : condition, rexBuilder);
        if (metadata != null) {
            this.result.put(sourceId, (Object)metadata);
        }
    }

    private static RexNode remapColumns(IgniteTable table, ImmutableBitSet requiredColumns, RexNode condition, RexBuilder rexBuilder) {
        Int2IntArrayMap mapping = new Int2IntArrayMap(requiredColumns.cardinality());
        int i = 0;
        Iterator iterator = requiredColumns.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)iterator.next();
            mapping.put(i, r);
            ++i;
        }
        RelDataType rowType = table.getRowType((RelDataTypeFactory)Commons.typeFactory(), requiredColumns);
        return (RexNode)condition.accept((RexVisitor)new RexShuttle((Int2IntMap)mapping, rowType, rexBuilder){
            final /* synthetic */ Int2IntMap val$mapping;
            final /* synthetic */ RelDataType val$rowType;
            final /* synthetic */ RexBuilder val$rexBuilder;
            {
                this.val$mapping = int2IntMap;
                this.val$rowType = relDataType;
                this.val$rexBuilder = rexBuilder;
            }

            public RexNode visitLocalRef(RexLocalRef localRef) {
                int fieldIdx = localRef.getIndex();
                int index = this.val$mapping.get(fieldIdx);
                RelDataType fieldType = ((RelDataTypeField)this.val$rowType.getFieldList().get(fieldIdx)).getType();
                return this.val$rexBuilder.makeLocalRef(fieldType, index);
            }
        });
    }

    @VisibleForTesting
    @Nullable
    public static PartitionPruningColumns extractMetadata(IntList keys, RexNode condition, RexBuilder rexBuilder) {
        PruningColumnSets columnSets;
        Result res = PartitionPruningMetadataExtractor.extractMetadata(condition, keys, rexBuilder, false);
        if (res == Result.UNKNOWN || res == Result.RESTRICT) {
            return null;
        }
        if (res instanceof PruningColumnSet) {
            PruningColumnSet columnSet = (PruningColumnSet)res;
            columnSets = new PruningColumnSets();
            columnSets.candidates.add(columnSet);
        } else {
            columnSets = (PruningColumnSets)res;
        }
        if (columnSets.candidates.isEmpty()) {
            return null;
        }
        for (PruningColumnSet columnSet : columnSets.candidates) {
            if (columnSet.columns.keySet().containsAll((IntCollection)keys)) continue;
            return null;
        }
        ArrayList<Int2ObjectMap<RexNode>> result = new ArrayList<Int2ObjectMap<RexNode>>(columnSets.candidates.size());
        for (PruningColumnSet columnSet : columnSets.candidates) {
            assert (!columnSet.columns.isEmpty()) : "Column set should not be empty";
            result.add(columnSet.columns);
        }
        return new PartitionPruningColumns(result);
    }

    private static Result extractMetadata(RexNode node, IntList keys, RexBuilder rexBuilder, boolean negate) {
        if (PartitionPruningMetadataExtractor.isColocationKey(node, keys)) {
            if (node.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                RexLocalRef ref = (RexLocalRef)node;
                return new PruningColumnSet(ref.getIndex(), (RexNode)rexBuilder.makeLiteral(!negate));
            }
        } else if (node.isA(SqlKind.LOCAL_REF)) {
            return Result.RESTRICT;
        }
        if (!(node instanceof RexCall)) {
            return Result.UNKNOWN;
        }
        List operands = ((RexCall)node).getOperands();
        switch (node.getKind()) {
            case IS_NOT_DISTINCT_FROM: 
            case EQUALS: {
                RexNode rhs;
                RexNode lhs;
                if (((RexNode)operands.get(0)).isA(SqlKind.LOCAL_REF)) {
                    lhs = (RexNode)operands.get(0);
                    rhs = (RexNode)operands.get(1);
                } else {
                    lhs = (RexNode)operands.get(1);
                    rhs = (RexNode)operands.get(0);
                }
                if (PartitionPruningMetadataExtractor.isColocationKey(lhs, keys) && PartitionPruningMetadataExtractor.isValueExpr(rhs)) {
                    if (negate) {
                        return Result.UNKNOWN;
                    }
                    RexLocalRef column = (RexLocalRef)lhs;
                    return new PruningColumnSet(column.getIndex(), rhs);
                }
                if (lhs.isA(SqlKind.LOCAL_REF) && PartitionPruningMetadataExtractor.isValueExpr(rhs)) {
                    return Result.RESTRICT;
                }
                return Result.UNKNOWN;
            }
            case NOT_EQUALS: 
            case IS_DISTINCT_FROM: {
                RexNode rhs;
                RexNode lhs;
                if (((RexNode)operands.get(0)).isA(SqlKind.LOCAL_REF)) {
                    lhs = (RexNode)operands.get(0);
                    rhs = (RexNode)operands.get(1);
                } else {
                    lhs = (RexNode)operands.get(1);
                    rhs = (RexNode)operands.get(0);
                }
                if (PartitionPruningMetadataExtractor.isColocationKey(lhs, keys) && PartitionPruningMetadataExtractor.isValueExpr(rhs)) {
                    if (negate) {
                        RexLocalRef column = (RexLocalRef)lhs;
                        return new PruningColumnSet(column.getIndex(), rhs);
                    }
                    return Result.UNKNOWN;
                }
                if (lhs.isA(SqlKind.LOCAL_REF) && PartitionPruningMetadataExtractor.isValueExpr(rhs)) {
                    return Result.RESTRICT;
                }
                return Result.UNKNOWN;
            }
            case OR: {
                PruningColumnSets res = new PruningColumnSets();
                for (RexNode operand : operands) {
                    Result child = PartitionPruningMetadataExtractor.extractMetadata(operand, keys, rexBuilder, negate);
                    if (child == Result.UNKNOWN || child == Result.RESTRICT) {
                        return Result.UNKNOWN;
                    }
                    res.add(child);
                }
                return res;
            }
            case AND: {
                PruningColumnSets res = new PruningColumnSets();
                for (RexNode operand : operands) {
                    Result child = PartitionPruningMetadataExtractor.extractMetadata(operand, keys, rexBuilder, negate);
                    if (child == Result.UNKNOWN) {
                        return Result.UNKNOWN;
                    }
                    if (child == Result.RESTRICT) continue;
                    res.combine(child);
                    if (!res.conflict) continue;
                    return Result.UNKNOWN;
                }
                return res;
            }
            case SEARCH: {
                RexNode expandedSearch = RexUtil.expandSearch((RexBuilder)rexBuilder, null, (RexNode)node);
                assert (!expandedSearch.isA(SqlKind.SEARCH)) : "Search operation is not expanded: " + String.valueOf(node);
                return PartitionPruningMetadataExtractor.extractMetadata(expandedSearch, keys, rexBuilder, false);
            }
            case NOT: {
                if (PartitionPruningMetadataExtractor.isColocationKey((RexNode)operands.get(0), keys)) {
                    RexLocalRef column = (RexLocalRef)operands.get(0);
                    return new PruningColumnSet(column.getIndex(), (RexNode)rexBuilder.makeLiteral(negate));
                }
                return PartitionPruningMetadataExtractor.extractMetadata((RexNode)operands.get(0), keys, rexBuilder, !negate);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                RexNode operand = (RexNode)operands.get(0);
                if (operand.isA(SqlKind.LOCAL_REF)) {
                    return Result.RESTRICT;
                }
                return Result.UNKNOWN;
            }
            case IS_FALSE: 
            case IS_TRUE: {
                RexNode operand = (RexNode)operands.get(0);
                if (PartitionPruningMetadataExtractor.isColocationKey(operand, keys)) {
                    RexLocalRef ref = (RexLocalRef)operand;
                    boolean value = negate ? node.getKind() == SqlKind.IS_FALSE : node.getKind() == SqlKind.IS_TRUE;
                    return new PruningColumnSet(ref.getIndex(), (RexNode)rexBuilder.makeLiteral(value));
                }
                if (operand.isA(SqlKind.LOCAL_REF)) {
                    return Result.RESTRICT;
                }
                return Result.UNKNOWN;
            }
            case IS_NOT_FALSE: 
            case IS_NOT_TRUE: {
                boolean value;
                if (negate) {
                    value = node.getKind() != SqlKind.IS_NOT_FALSE;
                } else {
                    boolean bl = value = node.getKind() != SqlKind.IS_NOT_TRUE;
                }
                if (PartitionPruningMetadataExtractor.isColocationKey((RexNode)operands.get(0), keys)) {
                    RexLocalRef column = (RexLocalRef)operands.get(0);
                    return new PruningColumnSet(column.getIndex(), (RexNode)rexBuilder.makeLiteral(value));
                }
                return PartitionPruningMetadataExtractor.extractMetadata((RexNode)operands.get(0), keys, rexBuilder, !negate);
            }
        }
        if (node.isA((Collection)SqlKind.BINARY_COMPARISON)) {
            RexNode rhs;
            RexNode lhs;
            if (((RexNode)operands.get(0)).isA(SqlKind.LOCAL_REF)) {
                lhs = (RexNode)operands.get(0);
                rhs = (RexNode)operands.get(1);
            } else {
                lhs = (RexNode)operands.get(1);
                rhs = (RexNode)operands.get(0);
            }
            if (PartitionPruningMetadataExtractor.isColocationKey(lhs, keys) && PartitionPruningMetadataExtractor.isValueExpr(rhs)) {
                return Result.UNKNOWN;
            }
            if (lhs.isA(SqlKind.LOCAL_REF) && PartitionPruningMetadataExtractor.isValueExpr(rhs)) {
                return Result.RESTRICT;
            }
            return Result.UNKNOWN;
        }
        return Result.UNKNOWN;
    }

    private static boolean isColocationKey(RexNode node, IntList keys) {
        if (node instanceof RexLocalRef) {
            RexLocalRef localRef = (RexLocalRef)node;
            return keys.contains(localRef.getIndex());
        }
        return false;
    }

    private static boolean isValueExpr(RexNode node) {
        return node instanceof RexLiteral || node instanceof RexDynamicParam || PartitionPruningMetadataExtractor.isCorrelatedVariable(node);
    }

    static boolean isCorrelatedVariable(RexNode node) {
        if (node.isA(SqlKind.FIELD_ACCESS)) {
            RexFieldAccess fieldAccess = (RexFieldAccess)node;
            return fieldAccess.getReferenceExpr().isA(SqlKind.CORREL_VARIABLE);
        }
        return false;
    }

    private static IntList distributionKeys(IgniteTable table) {
        IgniteDistribution distribution = table.distribution();
        if (!distribution.function().affinity()) {
            return IntArrayList.of();
        }
        IntArrayList keysList = new IntArrayList(distribution.getKeys().size());
        for (Integer key : distribution.getKeys()) {
            keysList.add(key.intValue());
        }
        return keysList;
    }

    private static abstract class Result {
        private static final Result UNKNOWN = new Result(){

            public String toString() {
                return "<unknown>";
            }
        };
        private static final Result RESTRICT = new Result(){

            public String toString() {
                return "<restrict>";
            }
        };

        private Result() {
        }
    }

    private static class PruningColumnSet
    extends Result {
        private final Int2ObjectMap<RexNode> columns;

        PruningColumnSet(Int2ObjectMap<RexNode> columns) {
            this.columns = columns;
        }

        PruningColumnSet(int column, RexNode value) {
            this.columns = new Int2ObjectArrayMap();
            this.columns.put(column, (Object)value);
        }

        public String toString() {
            return this.columns.toString();
        }
    }

    private static class PruningColumnSets
    extends Result {
        private final List<PruningColumnSet> candidates = new ArrayList<PruningColumnSet>();
        private boolean conflict;

        private PruningColumnSets() {
        }

        void add(Result res) {
            if (res instanceof PruningColumnSet) {
                PruningColumnSet columnSet = (PruningColumnSet)res;
                this.candidates.add(columnSet);
            } else {
                PruningColumnSets columnSets = (PruningColumnSets)res;
                this.candidates.addAll(columnSets.candidates);
            }
        }

        void combine(Result res) {
            if (this.candidates.isEmpty()) {
                if (res instanceof PruningColumnSet) {
                    PruningColumnSet columnSet = (PruningColumnSet)res;
                    this.candidates.add(columnSet);
                } else {
                    PruningColumnSets other = (PruningColumnSets)res;
                    this.candidates.addAll(other.candidates);
                }
            } else {
                PruningColumnSets other;
                if (this.conflict) {
                    return;
                }
                if (res instanceof PruningColumnSet) {
                    other = new PruningColumnSets();
                    other.candidates.add((PruningColumnSet)res);
                } else {
                    other = (PruningColumnSets)res;
                }
                ArrayList<PruningColumnSet> newOutput = new ArrayList<PruningColumnSet>();
                for (PruningColumnSet candidate : other.candidates) {
                    for (PruningColumnSet val : this.candidates) {
                        for (Int2ObjectMap.Entry ckv : candidate.columns.int2ObjectEntrySet()) {
                            Object existing;
                            if (!val.columns.containsKey(ckv.getIntKey()) || Objects.equals(existing = val.columns.get(ckv.getIntKey()), ckv.getValue())) continue;
                            this.conflict = true;
                            return;
                        }
                        Int2ObjectArrayMap newValue = new Int2ObjectArrayMap(val.columns.size() + candidate.columns.size());
                        newValue.putAll(val.columns);
                        newValue.putAll(candidate.columns);
                        PruningColumnSet newColSet = new PruningColumnSet((Int2ObjectMap<RexNode>)newValue);
                        newOutput.add(newColSet);
                    }
                }
                this.candidates.clear();
                this.candidates.addAll(newOutput);
            }
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

