/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.rule.logical.ImmutableProjectScanMergeRule;
import org.apache.ignite.internal.sql.engine.rule.logical.RuleFactoryConfig;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.immutables.value.Value;

@Value.Enclosing
public abstract class ProjectScanMergeRule<T extends ProjectableFilterableTableScan>
extends RelRule<Config> {
    public static final RelOptRule INDEX_SCAN = Config.INDEX_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN = Config.TABLE_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN_SKIP_CORRELATED = Config.TABLE_SCAN_SKIP_CORRELATED.toRule();
    public static final RelOptRule SYSTEM_VIEW_SCAN = Config.SYSTEM_VIEW_SCAN.toRule();
    public static final RelOptRule SYSTEM_VIEW_SCAN_SKIP_CORRELATED = Config.SYSTEM_VIEW_SCAN_SKIP_CORRELATED.toRule();

    protected abstract T createNode(RelOptCluster var1, T var2, RelTraitSet var3, List<RexNode> var4, RexNode var5, ImmutableBitSet var6);

    private ProjectScanMergeRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject relProject = (LogicalProject)call.rel(0);
        ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        RelOptCluster cluster = scan.getCluster();
        List projects = relProject.getProjects();
        RexNode cond = scan.condition();
        ImmutableBitSet requiredColumns = scan.requiredColumns();
        final List<RexNode> scanProjects = scan.projects();
        RelTraitSet traits = cluster.traitSet();
        IgniteDataSource tbl = (IgniteDataSource)scan.getTable().unwrap(IgniteDataSource.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
        if (requiredColumns == null) {
            assert (scanProjects == null);
            final ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    builder.set(ref.getIndex());
                    return ref;
                }
            }.apply(projects);
            new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef inputRef) {
                    builder.set(inputRef.getIndex());
                    return inputRef;
                }
            }.apply(cond);
            requiredColumns = builder.build();
            Mapping targetMapping = Commons.trimmingMapping(tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount(), requiredColumns);
            projects = new RexShuttle((Mappings.TargetMapping)targetMapping){
                final /* synthetic */ Mappings.TargetMapping val$targetMapping;
                {
                    this.val$targetMapping = targetMapping;
                }

                public RexNode visitInputRef(RexInputRef ref) {
                    return new RexLocalRef(this.val$targetMapping.getTarget(ref.getIndex()), ref.getType());
                }
            }.apply(projects);
            cond = new RexShuttle((Mappings.TargetMapping)targetMapping){
                final /* synthetic */ Mappings.TargetMapping val$targetMapping;
                {
                    this.val$targetMapping = targetMapping;
                }

                public RexNode visitLocalRef(RexLocalRef ref) {
                    return new RexLocalRef(this.val$targetMapping.getTarget(ref.getIndex()), ref.getType());
                }
            }.apply(cond);
        } else {
            projects = RexUtils.replaceInputRefs(projects);
        }
        if (scanProjects != null) {
            projects = new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef ref) {
                    return (RexNode)scanProjects.get(ref.getIndex());
                }
            }.apply(projects);
        }
        if (RexUtils.isIdentity(projects, tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns), true)) {
            projects = null;
        }
        call.transformTo((RelNode)this.createNode(cluster, scan, traits, projects, cond, requiredColumns));
        if (!RexUtils.hasCorrelation(relProject.getProjects())) {
            cluster.getPlanner().prune((RelNode)relProject);
        }
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RuleFactoryConfig<Config> {
        public static final Config DEFAULT = ImmutableProjectScanMergeRule.Config.builder().withRuleFactory((Config x$0) -> new ProjectTableScanMergeRule((Config)x$0)).build();
        public static final Config TABLE_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "ProjectTableScanMergeRule", false);
        public static final Config TABLE_SCAN_SKIP_CORRELATED = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "ProjectTableScanMergeSkipCorrelatedRule", true);
        public static final Config INDEX_SCAN = DEFAULT.withRuleFactory(x$0 -> new ProjectIndexScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalIndexScan.class, "ProjectIndexScanMergeRule", false);
        public static final Config SYSTEM_VIEW_SCAN = DEFAULT.withRuleFactory(x$0 -> new ProjectSystemViewScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalSystemViewScan.class, "ProjectSystemViewScanMergeRule", false);
        public static final Config SYSTEM_VIEW_SCAN_SKIP_CORRELATED = DEFAULT.withRuleFactory(x$0 -> new ProjectSystemViewScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalSystemViewScan.class, "ProjectSystemViewScanMergeSkipCorrelatedRule", true);

        default public Config withScanRuleConfig(Class<? extends ProjectableFilterableTableScan> scanCls, String desc, boolean skipCorrelated) {
            return (Config)this.withDescription(desc).withOperandSupplier(b -> b.operand(LogicalProject.class).predicate(p -> !skipCorrelated || !RexUtils.hasCorrelation(p.getProjects())).oneInput(b1 -> b1.operand(scanCls).noInputs())).as(Config.class);
        }
    }

    private static class ProjectSystemViewScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalSystemViewScan> {
        private ProjectSystemViewScanMergeRule(Config config) {
            super(config);
        }

        @Override
        protected IgniteLogicalSystemViewScan createNode(RelOptCluster cluster, IgniteLogicalSystemViewScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            return IgniteLogicalSystemViewScan.create(cluster, traits, (List<RelHint>)scan.getHints(), scan.getTable(), projections, cond, requiredColumns);
        }
    }

    private static class ProjectIndexScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalIndexScan> {
        private ProjectIndexScanMergeRule(Config config) {
            super(config);
        }

        @Override
        protected IgniteLogicalIndexScan createNode(RelOptCluster cluster, IgniteLogicalIndexScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            return IgniteLogicalIndexScan.create(cluster, traits, scan.getTable(), scan.indexName(), projections, cond, requiredColumns);
        }
    }

    private static class ProjectTableScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalTableScan> {
        private ProjectTableScanMergeRule(Config config) {
            super(config);
        }

        @Override
        protected IgniteLogicalTableScan createNode(RelOptCluster cluster, IgniteLogicalTableScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            return IgniteLogicalTableScan.create(cluster, traits, (List<RelHint>)scan.getHints(), scan.getTable(), projections, cond, requiredColumns);
        }
    }
}

