/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlTypeNameSpec;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeSpec;

public abstract class IgniteCustomType
extends RelDataTypeImpl {
    private final IgniteCustomTypeSpec spec;
    private final boolean nullable;
    private final int precision;

    protected IgniteCustomType(IgniteCustomTypeSpec spec, boolean nullable, int precision) {
        this.spec = spec;
        this.nullable = nullable;
        this.precision = precision;
        this.computeDigest();
    }

    public final String getCustomTypeName() {
        return this.spec.typeName();
    }

    public final IgniteCustomTypeSpec spec() {
        return this.spec;
    }

    public final boolean isNullable() {
        return this.nullable;
    }

    public RelDataTypeFamily getFamily() {
        return SqlTypeFamily.ANY;
    }

    public final SqlTypeName getSqlTypeName() {
        return SqlTypeName.ANY;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public abstract IgniteCustomType createWithNullability(boolean var1);

    public final SqlTypeNameSpec createTypeNameSpec() {
        SqlIdentifier typeNameId = new SqlIdentifier(this.getCustomTypeName(), SqlParserPos.ZERO);
        if (this.getPrecision() == -1) {
            return new IgniteSqlTypeNameSpec(typeNameId, SqlParserPos.ZERO);
        }
        SqlNumericLiteral precision = SqlLiteral.createExactNumeric((String)Integer.toString(this.getPrecision()), (SqlParserPos)SqlParserPos.ZERO);
        return new IgniteSqlTypeNameSpec(typeNameId, (SqlLiteral)precision, SqlParserPos.ZERO);
    }
}

