/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest;

import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.PathAvailability;
import org.apache.ignite.internal.rest.RestState;

public class RestManager {
    private static final IgniteLogger LOG = Loggers.forClass(RestManager.class);
    private static final String DURING_INITIALIZATION_TITLE = "REST temporarily unavailable";
    private static final String DURING_INITIALIZATION_REASON = "REST services are unavailable during cluster initialization";
    private static final String CLUSTER_NOT_INITIALIZED_TITLE = "Cluster is not initialized";
    private static final String CLUSTER_NOT_INITIALIZED_REASON = "Cluster is not initialized. Call /management/v1/cluster/init in order to initialize cluster.";
    private static final String[] DEFAULT_AVAILABLE_ON_START_ENDPOINTS = new String[]{"/management/v1/configuration/node", "/management/v1/cluster/init", "/management/v1/cluster/topology/physical", "/management/v1/node", "/management/v1/recovery/cluster"};
    private static final String[] DEFAULT_AVAILABLE_DURING_INITIALIZATION_ENDPOINTS = new String[]{"/management/v1/recovery/cluster"};
    private final String[] availableOnStartEndpoints;
    private final String[] availableDuringInitializationEndpoints;
    private RestState state = RestState.NOT_INITIALIZED;

    public RestManager() {
        this(DEFAULT_AVAILABLE_ON_START_ENDPOINTS, DEFAULT_AVAILABLE_DURING_INITIALIZATION_ENDPOINTS);
    }

    public RestManager(String[] availableOnStartEndpoints, String[] availableDuringInitializationEndpoints) {
        this.availableOnStartEndpoints = availableOnStartEndpoints;
        this.availableDuringInitializationEndpoints = availableDuringInitializationEndpoints;
    }

    public PathAvailability pathAvailability(String requestPath) {
        switch (this.state) {
            case INITIALIZED: {
                return PathAvailability.available();
            }
            case INITIALIZATION: {
                return this.pathDisabledForInitializationPhase(requestPath) ? PathAvailability.unavailable(DURING_INITIALIZATION_TITLE, DURING_INITIALIZATION_REASON) : PathAvailability.available();
            }
            case NOT_INITIALIZED: {
                return this.pathDisabledForNotInitializedCluster(requestPath) ? PathAvailability.unavailable(CLUSTER_NOT_INITIALIZED_TITLE, CLUSTER_NOT_INITIALIZED_REASON) : PathAvailability.available();
            }
        }
        throw new IllegalStateException("Unrecognized state " + String.valueOf((Object)this.state));
    }

    private boolean pathDisabledForInitializationPhase(String path) {
        for (String enabledPath : this.availableDuringInitializationEndpoints) {
            if (!path.startsWith(enabledPath)) continue;
            return false;
        }
        return true;
    }

    private boolean pathDisabledForNotInitializedCluster(String path) {
        for (String enabledPath : this.availableOnStartEndpoints) {
            if (!path.startsWith(enabledPath)) continue;
            return false;
        }
        return true;
    }

    void setState(RestState state) {
        if (state.ordinal() <= this.state.ordinal()) {
            LOG.error("Incorrect state transfer from " + String.valueOf((Object)this.state) + " to " + String.valueOf((Object)state), new Object[0]);
            return;
        }
        this.state = state;
    }
}

