/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.uzaygezen.core.Assessment;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.FilterCombiner;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.LinkedNodeList;
import com.google.uzaygezen.core.NodeList;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.Query;
import com.google.uzaygezen.core.QueryBuilder;
import com.google.uzaygezen.core.RegionInspector;
import com.google.uzaygezen.core.SelectiveFilter;
import com.google.uzaygezen.core.ranges.Range;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class BacktrackingQueryBuilder<F, T, V extends Content<V>, R extends Range<T, V>>
implements QueryBuilder<F, R> {
    private final RegionInspector<F, V> regionInspector;
    private final FilterCombiner<F, V, R> filterCombiner;
    private final int maxFilteredIndexRanges;
    private final boolean alwaysRemoveVacuum;
    private final RangeHome<T, V, R> rangeHome;
    private final V zero;
    private V currentGap;
    private final NodeList<FilteredIndexRange<F, R>> nodeList = LinkedNodeList.create();
    private final Queue<ComparableNode> minHeap = new PriorityQueue<ComparableNode>();
    private Pow2LengthBitSetRange lastFinishedIndexRange = null;
    private boolean potentialOverSelectivity;

    @Override
    public boolean visit(Pow2LengthBitSetRange indexRange, List<Pow2LengthBitSetRange> orthotope) {
        Preconditions.checkArgument((this.lastFinishedIndexRange == null || indexRange.getStart().compareTo(this.lastFinishedIndexRange.getStart()) > 0 ? 1 : 0) != 0);
        assert (this.lastFinishedIndexRange == null == (indexRange.getStart().length() == 0));
        assert (this.lastFinishedIndexRange == null || ((Range)this.rangeHome.toRange(this.lastFinishedIndexRange)).getEnd().equals(((Range)this.rangeHome.toRange(indexRange)).getStart())) : String.format("lastFinishedIndexRange=%s indeRange=%s", this.lastFinishedIndexRange, indexRange);
        Assessment<F, V> assessment = this.regionInspector.assess(indexRange, orthotope);
        switch (assessment.getOutcome()) {
            case OVERLAPS: {
                return true;
            }
            case COVERED: {
                this.processCoveredNode(indexRange, assessment.getFilter(), assessment.isPotentialOverSelectivity());
                this.potentialOverSelectivity |= assessment.isPotentialOverSelectivity();
                this.lastFinishedIndexRange = indexRange.clone();
                return false;
            }
            case DISJOINT: {
                this.processDisjointRegion((Content)assessment.getEstimate());
                this.lastFinishedIndexRange = indexRange.clone();
                return false;
            }
        }
        throw new RuntimeException("Cannot be: " + (Object)((Object)assessment.getOutcome()));
    }

    private void processCoveredNode(Pow2LengthBitSetRange indexBitSetRange, F filter, boolean potentialOverSelectivityInRange) {
        Range indexRange = (Range)this.rangeHome.toRange(indexBitSetRange);
        FilteredIndexRange<F, Range> indexQueryRange = new FilteredIndexRange<F, Range>(indexRange, filter, potentialOverSelectivityInRange);
        NodeList.Node<FilteredIndexRange<F, Object>> end = this.nodeList.isEmpty() ? null : this.nodeList.getNode(this.nodeList.size() - 1);
        if (this.alwaysRemoveVacuum & end != null & this.currentGap.isZero()) {
            SelectiveFilter<F> combinedFilter = this.filterCombiner.combine(end.get(), indexQueryRange, this.zero);
            end.set(new FilteredIndexRange<F, R>(this.rangeHome.of(((Range)end.get().getIndexRange()).getStart(), indexRange.getEnd()), combinedFilter.getFilter(), combinedFilter.isPotentialOverSelectivity() | potentialOverSelectivityInRange));
            this.potentialOverSelectivity |= combinedFilter.isPotentialOverSelectivity();
        } else {
            NodeList.Node<FilteredIndexRange<F, Range>> node = this.nodeList.addAndGetNode(indexQueryRange);
            if (end != null) {
                end = node;
                this.minHeap.add(new ComparableNode(this, this.currentGap, node));
                if (this.minHeap.size() >= this.maxFilteredIndexRanges) {
                    ComparableNode removed = this.minHeap.remove();
                    SelectiveFilter<F> combinedFilter = this.filterCombiner.combine((FilteredIndexRange)removed.node.previous().get(), (FilteredIndexRange)removed.node.get(), removed.leftGapEstimate);
                    this.potentialOverSelectivity |= combinedFilter.isPotentialOverSelectivity();
                    removed.node.previous().set(new FilteredIndexRange<F, R>(this.rangeHome.of(((Range)((FilteredIndexRange)removed.node.previous().get()).getIndexRange()).getStart(), ((Range)((FilteredIndexRange)removed.node.get()).getIndexRange()).getEnd()), combinedFilter.getFilter(), combinedFilter.isPotentialOverSelectivity() | potentialOverSelectivityInRange));
                    removed.node.remove();
                }
            }
            this.currentGap = (Content)this.zero.clone();
        }
    }

    private void processDisjointRegion(V gapEstimate) {
        if (!this.nodeList.isEmpty()) {
            this.currentGap.add(gapEstimate);
        }
    }

    public Query<F, R> get() {
        return Query.of(ImmutableList.copyOf(this.nodeList));
    }

    public static <F, T, V extends Content<V>, R extends Range<T, V>> BacktrackingQueryBuilder<F, T, V, R> create(RegionInspector<F, V> regionInspector, FilterCombiner<F, V, R> intervalCombiner, int maxFilteredIndexRanges, boolean removeVacuum, RangeHome<T, V, R> rangeHome, V zero) {
        return new BacktrackingQueryBuilder<F, T, V, R>(regionInspector, intervalCombiner, maxFilteredIndexRanges, removeVacuum, rangeHome, zero);
    }

    public BacktrackingQueryBuilder(RegionInspector<F, V> regionInspector, FilterCombiner<F, V, R> intervalCombiner, int maxFilteredIndexRanges, boolean alwaysRemoveVacuum, RangeHome<T, V, R> rangeHome, V zero) {
        this.regionInspector = regionInspector;
        this.filterCombiner = intervalCombiner;
        Preconditions.checkArgument((maxFilteredIndexRanges > 0 ? 1 : 0) != 0, (Object)"maxFilteredIndexRanges must be positive");
        this.maxFilteredIndexRanges = maxFilteredIndexRanges;
        this.alwaysRemoveVacuum = alwaysRemoveVacuum;
        this.rangeHome = rangeHome;
        this.zero = zero;
        this.currentGap = (Content)zero.clone();
    }

    private static class ComparableNode
    implements Comparable<ComparableNode> {
        private final V leftGapEstimate;
        private final NodeList.Node<FilteredIndexRange<F, R>> node;
        final /* synthetic */ BacktrackingQueryBuilder this$0;

        public ComparableNode(V leftGapEstimate, NodeList.Node<FilteredIndexRange<F, R>> node) {
            this.this$0 = var1_1;
            this.leftGapEstimate = leftGapEstimate;
            this.node = (NodeList.Node)Preconditions.checkNotNull(node, (Object)"node");
        }

        @Override
        public int compareTo(ComparableNode other) {
            return this.leftGapEstimate.compareTo(other.leftGapEstimate);
        }
    }
}

