/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.server.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.network.ClusterNode;

public class RaftServiceEventInterceptor {
    private ConcurrentHashMap<ReplicationGroupId, Set<Consumer<Long>>> subscriptions = new ConcurrentHashMap();
    private ConcurrentHashMap<ClusterNode, Set<Consumer<Long>>> nodesSubscriptions = new ConcurrentHashMap();

    public void subscribe(ReplicationGroupId groupId, ClusterNode subscriber, Consumer<Long> notifyAction) {
        this.subscriptions.compute(groupId, (id, actions) -> {
            if (actions == null) {
                actions = new HashSet<Consumer>();
            }
            HashSet<Consumer> finalActions = actions;
            this.nodesSubscriptions.compute(subscriber, (node, nodeActions) -> {
                if (!CollectionUtils.nullOrEmpty((Collection)finalActions) && !CollectionUtils.nullOrEmpty((Collection)nodeActions)) {
                    return nodeActions;
                }
                if (nodeActions == null) {
                    nodeActions = new HashSet<Consumer>();
                }
                nodeActions.add(notifyAction);
                return nodeActions;
            });
            actions.add(notifyAction);
            return actions;
        });
    }

    public void unsubscribe(ReplicationGroupId groupId, ClusterNode subscriber) {
        this.subscriptions.computeIfPresent(groupId, (id, actions) -> {
            this.nodesSubscriptions.computeIfPresent(subscriber, (node, nodeActions) -> {
                HashSet grpNodeActions = new HashSet(actions);
                grpNodeActions.retainAll((Collection<?>)nodeActions);
                if (CollectionUtils.nullOrEmpty(grpNodeActions)) {
                    return nodeActions;
                }
                assert (grpNodeActions.size() == 1) : "Node is not subscribed [node=" + String.valueOf(subscriber) + "groupId=" + String.valueOf(groupId) + "]";
                Consumer actionToRemove = (Consumer)grpNodeActions.iterator().next();
                nodeActions.remove(actionToRemove);
                actions.remove(actionToRemove);
                if (CollectionUtils.nullOrEmpty((Collection)nodeActions)) {
                    return null;
                }
                return nodeActions;
            });
            if (CollectionUtils.nullOrEmpty((Collection)actions)) {
                return null;
            }
            return actions;
        });
    }

    public void unsubscribeNode(ClusterNode clusterNode) {
        for (ReplicationGroupId grpId : this.subscriptions.keySet()) {
            this.unsubscribe(grpId, clusterNode);
        }
    }

    public void onLeaderElected(ReplicationGroupId groupId, long term) {
        HashSet actionsToInvoke = new HashSet();
        this.subscriptions.computeIfPresent(groupId, (id, actions) -> {
            actionsToInvoke.addAll(actions);
            return actions;
        });
        for (Consumer action : actionsToInvoke) {
            action.accept(term);
        }
    }
}

