/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageException;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorage;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorageUtils;
import org.apache.ignite.internal.rocksdb.LoggingRocksDbFlushListener;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.Platform;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.Priority;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class DefaultLogStorageFactory
implements LogStorageFactory {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultLogStorageFactory.class);
    private final String factoryName;
    private final Path logPath;
    private final ExecutorService executorService;
    private RocksDB db;
    private DBOptions dbOptions;
    private WriteOptions writeOptions;
    private ColumnFamilyHandle confHandle;
    private ColumnFamilyHandle dataHandle;
    private ColumnFamilyOptions cfOption;
    private AbstractEventListener flushListener;
    private final boolean fsync;
    private final ThreadLocal<WriteBatch> threadLocalWriteBatch = new ThreadLocal();

    @TestOnly
    public DefaultLogStorageFactory(Path path) {
        this("test", "test", path, true);
    }

    public DefaultLogStorageFactory(String factoryName, String nodeName, Path logPath, boolean fsync) {
        this.factoryName = factoryName;
        this.logPath = logPath;
        this.fsync = fsync;
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"raft-shared-log-storage-pool", (IgniteLogger)LOG));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        try {
            this.start();
            return CompletableFutures.nullCompletedFuture();
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    private void start() throws Exception {
        try {
            Files.createDirectories(this.logPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory: " + String.valueOf(this.logPath), e);
        }
        ArrayList columnFamilyHandles = new ArrayList();
        this.dbOptions = this.createDbOptions();
        this.writeOptions = new WriteOptions().setSync(this.dbOptions.useFsync());
        this.cfOption = DefaultLogStorageFactory.createColumnFamilyOptions();
        this.flushListener = new LoggingRocksDbFlushListener(this.factoryName);
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = List.of(new ColumnFamilyDescriptor("Configuration".getBytes(StandardCharsets.UTF_8), this.cfOption), new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, this.cfOption));
        try {
            this.dbOptions.setListeners(List.of(this.flushListener));
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.logPath.toString(), columnFamilyDescriptors, columnFamilyHandles);
            Env env = this.db.getEnv();
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.HIGH);
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.LOW);
            assert (columnFamilyHandles.size() == 2);
            this.confHandle = (ColumnFamilyHandle)columnFamilyHandles.get(0);
            this.dataHandle = (ColumnFamilyHandle)columnFamilyHandles.get(1);
        }
        catch (Exception e) {
            this.closeRocksResources();
            throw e;
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.executorService);
        try {
            this.closeRocksResources();
        }
        catch (RuntimeException ex) {
            return CompletableFuture.failedFuture(ex);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void closeRocksResources() {
        ArrayList<Object> closables = new ArrayList<Object>();
        closables.add(this.confHandle);
        closables.add(this.dataHandle);
        closables.add(this.db);
        closables.add(this.dbOptions);
        closables.add(this.cfOption);
        closables.add(this.flushListener);
        closables.add(this.writeOptions);
        RocksUtils.closeAll(closables);
    }

    @Override
    public LogStorage createLogStorage(String raftNodeStorageId, RaftOptions raftOptions) {
        return new RocksDbSharedLogStorage(this, this.db, this.confHandle, this.dataHandle, raftNodeStorageId, this.writeOptions, this.executorService);
    }

    @Override
    public void destroyLogStorage(String uri) {
        try {
            RocksDbSharedLogStorage.destroyAllEntriesBetween(this.db, this.confHandle, this.dataHandle, RocksDbSharedLogStorageUtils.raftNodeStorageStartPrefix(uri), RocksDbSharedLogStorageUtils.raftNodeStorageEndPrefix(uri));
        }
        catch (RocksDBException e) {
            throw new LogStorageException("Fail to destroy the log storage for " + uri, e);
        }
    }

    public void sync() throws RocksDBException {
        if (!this.dbOptions.useFsync()) {
            this.db.syncWal();
        }
    }

    WriteBatch getOrCreateThreadLocalWriteBatch() {
        WriteBatch writeBatch = this.threadLocalWriteBatch.get();
        if (writeBatch == null) {
            writeBatch = new WriteBatch();
            this.threadLocalWriteBatch.set(writeBatch);
        }
        return writeBatch;
    }

    @Nullable
    WriteBatch getThreadLocalWriteBatch() {
        return this.threadLocalWriteBatch.get();
    }

    void clearThreadLocalWriteBatch(WriteBatch writeBatch) {
        writeBatch.close();
        this.threadLocalWriteBatch.remove();
    }

    protected DBOptions createDbOptions() {
        return new DBOptions().setMaxBackgroundJobs(Runtime.getRuntime().availableProcessors() * 2).setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setUseFsync(this.fsync);
    }

    @TestOnly
    @Nullable
    public DBOptions dbOptions() {
        return this.dbOptions;
    }

    @TestOnly
    @Nullable
    public WriteOptions writeOptions() {
        return this.writeOptions;
    }

    private static ColumnFamilyOptions createColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(5);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(50);
        opts.setLevel0SlowdownWritesTrigger(100);
        opts.setLevel0StopWritesTrigger(200);
        opts.setMaxBytesForLevelBase(0xC8000000L);
        opts.setTargetFileSizeBase(0x14000000L);
        if (!Platform.isWindows()) {
            opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        }
        return opts;
    }
}

