/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.RhsPadding;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class Sequence
extends RhsPadding {
    static final long INITIAL_VALUE = -1L;
    private static final VarHandle VALUE_FIELD;

    public Sequence() {
        this(-1L);
    }

    public Sequence(long initialValue) {
        VarHandle.releaseFence();
        this.value = initialValue;
    }

    public long get() {
        long value = this.value;
        VarHandle.acquireFence();
        return value;
    }

    public void set(long value) {
        VarHandle.releaseFence();
        this.value = value;
    }

    public void setVolatile(long value) {
        VarHandle.releaseFence();
        this.value = value;
        VarHandle.fullFence();
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return VALUE_FIELD.compareAndSet(this, expectedValue, newValue);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        return VALUE_FIELD.getAndAdd(this, increment) + increment;
    }

    public long getAndAdd(long increment) {
        return VALUE_FIELD.getAndAdd(this, increment);
    }

    public String toString() {
        return Long.toString(this.get());
    }

    static {
        try {
            VALUE_FIELD = MethodHandles.lookup().in(Sequence.class).findVarHandle(Sequence.class, "value", Long.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

