/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.disaster.system;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.disaster.system.message.BecomeMetastorageLeaderMessage;
import org.apache.ignite.internal.disaster.system.message.StartMetastorageRepairRequest;
import org.apache.ignite.internal.disaster.system.message.StartMetastorageRepairResponse;
import org.apache.ignite.internal.disaster.system.message.SystemDisasterRecoveryMessagesFactory;
import org.apache.ignite.internal.disaster.system.repair.MetastorageRepair;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.raft.IndexWithTerm;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.network.ClusterNode;

public class MetastorageRepairImpl
implements MetastorageRepair {
    private static final IgniteLogger LOG = Loggers.forClass(MetastorageRepairImpl.class);
    private static final long WAIT_FOR_NODES_SECONDS = 60L;
    private final MessagingService messagingService;
    private final LogicalTopology logicalTopology;
    private final ClusterManagementGroupManager cmgManager;
    private final SystemDisasterRecoveryMessagesFactory messagesFactory = new SystemDisasterRecoveryMessagesFactory();

    public MetastorageRepairImpl(MessagingService messagingService, LogicalTopology logicalTopology, ClusterManagementGroupManager cmgManager) {
        this.messagingService = messagingService;
        this.logicalTopology = logicalTopology;
        this.cmgManager = cmgManager;
    }

    public CompletableFuture<Void> repair(Set<String> participatingNodeNames, int metastorageReplicationFactor) {
        LOG.info("Starting MG repair [participatingNodes={}, replicationFactor={}].", new Object[]{participatingNodeNames, metastorageReplicationFactor});
        return ((CompletableFuture)this.waitTillValidatedNodesContain(participatingNodeNames).thenCompose(unused -> this.startMetastorageRepair(participatingNodeNames))).thenCompose(indexes -> {
            LOG.info("Collected metastorage indexes [indexes={}].", new Object[]{indexes});
            Set<String> newMgNodes = MetastorageRepairImpl.nodesWithBestIndexes(indexes, metastorageReplicationFactor);
            LOG.info("Chose new MG nodes [mgNodes={}].", new Object[]{newMgNodes});
            String bestNodeName = MetastorageRepairImpl.chooseNodeWithBestIndex(indexes, newMgNodes);
            LOG.info("Chose best MG node [node={}].", new Object[]{bestNodeName});
            long bestIndex = ((IndexWithTerm)indexes.get(bestNodeName)).index();
            return ((CompletableFuture)this.cmgManager.changeMetastorageNodes(newMgNodes, bestIndex + 1L).thenCompose(unused -> this.appointLeader(bestNodeName, ((IndexWithTerm)indexes.get(bestNodeName)).term(), newMgNodes))).thenRun(() -> LOG.info("Appointed MG leader forcefully [leader={}].", new Object[]{bestNodeName}));
        });
    }

    private CompletableFuture<Void> waitTillValidatedNodesContain(final Set<String> nodeNames) {
        final ConcurrentHashMap.KeySetView cumulativeValidatedNodeNames = ConcurrentHashMap.newKeySet();
        final CompletableFuture future = new CompletableFuture();
        LogicalTopologyEventListener listener = new LogicalTopologyEventListener(){

            public void onNodeValidated(LogicalNode validatedNode) {
                LOG.info("Node (awaited by Metastorage repair) has been validated in CMG: {}", new Object[]{validatedNode.name()});
                this.markNodeAsAdded(validatedNode);
            }

            public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
                LOG.info("Node (awaited by Metastorage repair) has joined the cluster: {}", new Object[]{joinedNode.name()});
                this.markNodeAsAdded(joinedNode);
            }

            private void markNodeAsAdded(LogicalNode validatedNode) {
                cumulativeValidatedNodeNames.add(validatedNode.name());
                if (MetastorageRepairImpl.isSuperset(cumulativeValidatedNodeNames, nodeNames)) {
                    future.complete(null);
                }
            }

            public void onNodeInvalidated(LogicalNode invalidatedNode) {
                LOG.info("Node (awaited by Metastorage repair) has been invalidated in CMG: {}", new Object[]{invalidatedNode.name()});
                cumulativeValidatedNodeNames.remove(invalidatedNode.name());
            }
        };
        this.logicalTopology.addEventListener(listener);
        this.cmgManager.validatedNodes().thenAccept(validatedNodes -> {
            Set<String> validatedNodeNames = validatedNodes.stream().map(ClusterNode::name).collect(Collectors.toSet());
            LOG.info("Nodes (awaited by Metastorage repair) that are currently validated/joined in CMG: {}", new Object[]{validatedNodeNames});
            if (MetastorageRepairImpl.isSuperset(validatedNodeNames, nodeNames)) {
                future.complete(null);
            }
            cumulativeValidatedNodeNames.addAll(validatedNodeNames);
        });
        return future.orTimeout(60L, TimeUnit.SECONDS).whenComplete((res, ex) -> {
            this.logicalTopology.removeEventListener(listener);
            if (ex instanceof TimeoutException) {
                LOG.error("Did not see all participating nodes online in time, failing Metastorage repair, please try again", ex);
            }
        });
    }

    private static boolean isSuperset(Set<String> container, Set<String> containee) {
        return CollectionUtils.difference(containee, container).isEmpty();
    }

    private CompletableFuture<Map<String, IndexWithTerm>> startMetastorageRepair(Set<String> participatingNodeNames) {
        LOG.info("Sending StartMetastorageRepair requests to {}", new Object[]{participatingNodeNames});
        StartMetastorageRepairRequest request = this.messagesFactory.startMetastorageRepairRequest().build();
        HashMap<String, CompletionStage> responses = new HashMap<String, CompletionStage>();
        for (String nodeName : participatingNodeNames) {
            responses.put(nodeName, this.messagingService.invoke(nodeName, (NetworkMessage)request, 10000L).thenApply(StartMetastorageRepairResponse.class::cast));
        }
        return CompletableFutures.allOf(responses.values()).thenApply(unused -> responses.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> MetastorageRepairImpl.indexWithTerm((StartMetastorageRepairResponse)((CompletableFuture)entry.getValue()).join()))));
    }

    private static IndexWithTerm indexWithTerm(StartMetastorageRepairResponse message) {
        return new IndexWithTerm(message.raftIndex(), message.raftTerm());
    }

    private static Set<String> nodesWithBestIndexes(Map<String, IndexWithTerm> indexes, int metastorageReplicationFactor) {
        return indexes.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(metastorageReplicationFactor).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static String chooseNodeWithBestIndex(Map<String, IndexWithTerm> indexes, Set<String> newMgNodes) {
        return newMgNodes.stream().max(Comparator.comparing(indexes::get)).orElseThrow();
    }

    private CompletableFuture<Void> appointLeader(String bestNodeName, long termBeforeChange, Set<String> newMgNodes) {
        LOG.info("Appointing MG leader forcefully [leader={}].", new Object[]{bestNodeName});
        BecomeMetastorageLeaderMessage request = this.messagesFactory.becomeMetastorageLeaderMessage().termBeforeChange(termBeforeChange).targetVotingSet(Set.copyOf(newMgNodes)).build();
        return this.messagingService.invoke(bestNodeName, (NetworkMessage)request, 10000L).thenApply(message -> null);
    }
}

