/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMetaAbandoned;
import org.apache.ignite.internal.tx.TxStateMetaFinishing;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateMetaMessage;
import org.jetbrains.annotations.Nullable;

public class TxStateMeta
implements TransactionMeta {
    private static final long serialVersionUID = 8521181896862227127L;
    private final TxState txState;
    @Nullable
    private final UUID txCoordinatorId;
    @Nullable
    private final TablePartitionId commitPartitionId;
    @Nullable
    private final HybridTimestamp commitTimestamp;
    @Nullable
    private final Long initialVacuumObservationTimestamp;
    @Nullable
    private final Long cleanupCompletionTimestamp;

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable TablePartitionId commitPartitionId, @Nullable HybridTimestamp commitTimestamp) {
        this(txState, txCoordinatorId, commitPartitionId, commitTimestamp, null, null);
    }

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable TablePartitionId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable Long initialVacuumObservationTimestamp) {
        this(txState, txCoordinatorId, commitPartitionId, commitTimestamp, initialVacuumObservationTimestamp, null);
    }

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable TablePartitionId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable Long initialVacuumObservationTimestamp, @Nullable Long cleanupCompletionTimestamp) {
        this.txState = txState;
        this.txCoordinatorId = txCoordinatorId;
        this.commitPartitionId = commitPartitionId;
        this.commitTimestamp = commitTimestamp;
        this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp;
        this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
    }

    public TxStateMetaAbandoned abandoned() {
        assert (TxState.checkTransitionCorrectness(this.txState, TxState.ABANDONED)) : "Transaction state is incorrect [txState=" + String.valueOf((Object)this.txState) + "].";
        return new TxStateMetaAbandoned(this.txCoordinatorId, this.commitPartitionId);
    }

    public TxStateMetaFinishing finishing() {
        return new TxStateMetaFinishing(this.txCoordinatorId, this.commitPartitionId);
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    @Nullable
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Nullable
    public TablePartitionId commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Nullable
    public Long initialVacuumObservationTimestamp() {
        return this.initialVacuumObservationTimestamp;
    }

    @Nullable
    public Long cleanupCompletionTimestamp() {
        return this.cleanupCompletionTimestamp;
    }

    @Override
    public TxStateMetaMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        return txMessagesFactory.txStateMetaMessage().txState(this.txState).txCoordinatorId(this.txCoordinatorId).commitPartitionId(this.commitPartitionId == null ? null : ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)replicaMessagesFactory, (TablePartitionId)this.commitPartitionId)).commitTimestamp(this.commitTimestamp).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxStateMeta that = (TxStateMeta)o;
        if (this.txState != that.txState) {
            return false;
        }
        if (this.txCoordinatorId != null ? !this.txCoordinatorId.equals(that.txCoordinatorId) : that.txCoordinatorId != null) {
            return false;
        }
        if (this.commitPartitionId != null ? !this.commitPartitionId.equals((Object)that.commitPartitionId) : that.commitPartitionId != null) {
            return false;
        }
        if (this.commitTimestamp != null ? !this.commitTimestamp.equals((Object)that.commitTimestamp) : that.commitTimestamp != null) {
            return false;
        }
        if (this.initialVacuumObservationTimestamp != null ? !this.initialVacuumObservationTimestamp.equals(that.initialVacuumObservationTimestamp) : that.initialVacuumObservationTimestamp != null) {
            return false;
        }
        return this.cleanupCompletionTimestamp != null ? this.cleanupCompletionTimestamp.equals(that.cleanupCompletionTimestamp) : that.cleanupCompletionTimestamp == null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.txState, this.txCoordinatorId, this.commitPartitionId, this.commitTimestamp, this.initialVacuumObservationTimestamp, this.cleanupCompletionTimestamp});
    }

    public String toString() {
        return S.toString(TxStateMeta.class, (Object)this);
    }
}

