/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.IgniteAbstractTransactionImpl;
import org.apache.ignite.internal.tx.impl.TransactionsExceptionMapperUtil;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class ReadWriteTransactionImpl
extends IgniteAbstractTransactionImpl {
    private static final AtomicReferenceFieldUpdater<ReadWriteTransactionImpl, TablePartitionId> COMMIT_PART_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ReadWriteTransactionImpl.class, TablePartitionId.class, "commitPart");
    private final Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlisted = new ConcurrentHashMap<TablePartitionId, IgniteBiTuple<ClusterNode, Long>>();
    private volatile TablePartitionId commitPart;
    private final ReentrantReadWriteLock enlistPartitionLock = new ReentrantReadWriteLock();
    private volatile CompletableFuture<Void> finishFuture;

    public ReadWriteTransactionImpl(TxManager txManager, HybridTimestampTracker observableTsTracker, UUID id, UUID txCoordinatorId, boolean implicit) {
        super(txManager, observableTsTracker, id, txCoordinatorId, implicit);
    }

    @Override
    public boolean assignCommitPartition(TablePartitionId tablePartitionId) {
        return COMMIT_PART_UPDATER.compareAndSet(this, null, tablePartitionId);
    }

    @Override
    public TablePartitionId commitPartition() {
        return this.commitPart;
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlistedNodeAndConsistencyToken(TablePartitionId partGroupId) {
        return this.enlisted.get(partGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteBiTuple<ClusterNode, Long> enlist(TablePartitionId tablePartitionId, IgniteBiTuple<ClusterNode, Long> nodeAndConsistencyToken) {
        if (!this.enlistPartitionLock.readLock().tryLock()) {
            this.failEnlist();
            assert (false);
        }
        try {
            this.checkEnlistPossibility();
            IgniteBiTuple igniteBiTuple = this.enlisted.computeIfAbsent(tablePartitionId, k -> nodeAndConsistencyToken);
            return igniteBiTuple;
        }
        finally {
            this.enlistPartitionLock.readLock().unlock();
        }
    }

    private void failEnlist() {
        throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is already finished [id={}, state={}].", (Object[])new Object[]{this.id(), this.state()}));
    }

    private void checkEnlistPossibility() {
        if (this.isFinishingOrFinished()) {
            this.failEnlist();
        }
    }

    public CompletableFuture<Void> commitAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(true, null, false), ErrorGroups.Transactions.TX_COMMIT_ERR);
    }

    public CompletableFuture<Void> rollbackAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, null, false), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> finish(boolean commit, @Nullable HybridTimestamp executionTimestamp, boolean full) {
        if (this.finishFuture != null) {
            return this.finishFuture;
        }
        this.enlistPartitionLock.writeLock().lock();
        try {
            if (this.finishFuture == null) {
                if (full) {
                    this.txManager.finishFull(this.observableTsTracker, this.id(), executionTimestamp, commit);
                    this.finishFuture = CompletableFutures.nullCompletedFuture();
                } else {
                    CompletableFuture<Void> finishFutureInternal = this.finishInternal(commit);
                    this.finishFuture = finishFutureInternal.handle((unused, throwable) -> null);
                    CompletableFuture<Void> completableFuture = finishFutureInternal;
                    return completableFuture;
                }
            }
            CompletableFuture<Void> completableFuture = this.finishFuture;
            return completableFuture;
        }
        finally {
            this.enlistPartitionLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.finishFuture != null;
    }

    private CompletableFuture<Void> finishInternal(boolean commit) {
        return this.txManager.finish(this.observableTsTracker, this.commitPart, commit, this.enlisted, this.id());
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return null;
    }

    @Override
    public HybridTimestamp startTimestamp() {
        return TransactionIds.beginTimestamp(this.id());
    }
}

