/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineExtensionConfiguration;
import org.jetbrains.annotations.Nullable;

@AutoService(value={DataStorageModule.class})
public class RocksDbDataStorageModule
implements DataStorageModule {
    public String name() {
        return "rocksdb";
    }

    public StorageEngine createEngine(String igniteInstanceName, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) throws StorageException {
        StorageConfiguration storageConfig = ((StorageExtensionConfiguration)configRegistry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        RocksDbStorageEngineConfiguration engineConfig = ((RocksDbStorageEngineExtensionConfiguration)storageConfig.engines()).rocksdb();
        assert (engineConfig != null);
        return new RocksDbStorageEngine(igniteInstanceName, engineConfig, storageConfig, storagePath, logSyncer, commonScheduler);
    }
}

