/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.MergedField;
import org.apache.ignite.internal.network.serialization.MergedLayer;

class ClassDescriptorMerger {
    ClassDescriptorMerger() {
    }

    static List<MergedField> mergeFields(List<FieldDescriptor> localFields, List<FieldDescriptor> remoteFields) {
        FieldDescriptor remoteField;
        ArrayList<MergedField> mergedFields = new ArrayList<MergedField>();
        int remoteFieldCount = remoteFields.size();
        int localFieldCount = localFields.size();
        int remoteFieldIndex = 0;
        int localFieldIndex = 0;
        while (remoteFieldIndex < remoteFieldCount && localFieldIndex < localFieldCount) {
            remoteField = remoteFields.get(remoteFieldIndex);
            FieldDescriptor localField = localFields.get(localFieldIndex);
            int remoteToLocal = remoteField.name().compareTo(localField.name());
            MergedField mergedField = remoteToLocal > 0 ? MergedField.localOnly(localField) : (remoteToLocal < 0 ? MergedField.remoteOnly(remoteField) : new MergedField(localField, remoteField));
            mergedFields.add(mergedField);
            if (remoteToLocal >= 0) {
                ++localFieldIndex;
            }
            if (remoteToLocal > 0) continue;
            ++remoteFieldIndex;
        }
        while (remoteFieldIndex < remoteFieldCount) {
            remoteField = remoteFields.get(remoteFieldIndex);
            mergedFields.add(MergedField.remoteOnly(remoteField));
            ++remoteFieldIndex;
        }
        while (localFieldIndex < localFieldCount) {
            FieldDescriptor localField = localFields.get(localFieldIndex);
            mergedFields.add(MergedField.localOnly(localField));
            ++localFieldIndex;
        }
        return List.copyOf(mergedFields);
    }

    static List<MergedLayer> mergeLineages(List<ClassDescriptor> localLineage, List<ClassDescriptor> remoteLineage) {
        int remoteIndex;
        Set<String> commonClassNames = ClassDescriptorMerger.classNames(localLineage);
        commonClassNames.retainAll(ClassDescriptorMerger.classNames(remoteLineage));
        Predicate<ClassDescriptor> isCommon = layer -> commonClassNames.contains(layer.className());
        ArrayList<MergedLayer> result = new ArrayList<MergedLayer>();
        int localIndex = 0;
        for (remoteIndex = 0; localIndex < localLineage.size() && remoteIndex < remoteLineage.size(); ++localIndex, ++remoteIndex) {
            while (localIndex < localLineage.size() && !isCommon.test(localLineage.get(localIndex))) {
                result.add(MergedLayer.localOnly(localLineage.get(localIndex)));
                ++localIndex;
            }
            while (remoteIndex < remoteLineage.size() && !isCommon.test(remoteLineage.get(remoteIndex))) {
                result.add(MergedLayer.remoteOnly(remoteLineage.get(remoteIndex)));
                ++remoteIndex;
            }
            if (localIndex >= localLineage.size() || remoteIndex >= remoteLineage.size()) break;
            ClassDescriptor localLayer = localLineage.get(localIndex);
            ClassDescriptor remoteLayer = remoteLineage.get(remoteIndex);
            result.add(new MergedLayer(localLayer, remoteLayer));
        }
        while (localIndex < localLineage.size()) {
            result.add(MergedLayer.localOnly(localLineage.get(localIndex)));
            ++localIndex;
        }
        while (remoteIndex < remoteLineage.size()) {
            result.add(MergedLayer.remoteOnly(remoteLineage.get(remoteIndex)));
            ++remoteIndex;
        }
        return List.copyOf(result);
    }

    private static Set<String> classNames(List<ClassDescriptor> localLineage) {
        return localLineage.stream().map(ClassDescriptor::className).collect(Collectors.toSet());
    }
}

