/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import java.util.UUID;
import org.apache.ignite.internal.lang.ErrorGroupHelper;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TraceableException;
import org.apache.ignite.lang.util.TraceIdUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteInternalException
extends RuntimeException
implements TraceableException {
    private static final long serialVersionUID = 0L;
    private final String errorPrefix;
    private final String groupName;
    private final int code;
    private UUID traceId;

    public IgniteInternalException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteInternalException(UUID traceId, int code) {
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode((int)code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteInternalException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteInternalException(UUID traceId, int code, String message) {
        super(message);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode((int)code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteInternalException(int code, @Nullable Throwable cause) {
        this(TraceIdUtils.getOrCreateTraceId((Throwable)cause), code, cause);
    }

    public IgniteInternalException(UUID traceId, int code, @Nullable Throwable cause) {
        super(cause != null ? cause.getLocalizedMessage() : null, cause);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode((int)code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteInternalException(int code, String message, @Nullable Throwable cause) {
        this(TraceIdUtils.getOrCreateTraceId((Throwable)cause), code, message, cause);
    }

    public IgniteInternalException(UUID traceId, int code, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode((int)code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    @Deprecated
    public IgniteInternalException() {
        this(ErrorGroups.Common.INTERNAL_ERR);
    }

    @Deprecated
    public IgniteInternalException(String msg) {
        this(ErrorGroups.Common.INTERNAL_ERR, msg);
    }

    @Deprecated
    public IgniteInternalException(Throwable cause) {
        this(ErrorGroups.Common.INTERNAL_ERR, cause);
    }

    @Deprecated
    public IgniteInternalException(String msg, @Nullable Throwable cause) {
        this(ErrorGroups.Common.INTERNAL_ERR, msg, cause);
    }

    public IgniteInternalException(int code, String messagePattern, Object ... params) {
        this(code, IgniteStringFormatter.format(messagePattern, params));
    }

    public IgniteInternalException(int code, String messagePattern, @Nullable Throwable cause, Object ... params) {
        this(code, IgniteStringFormatter.format(messagePattern, params), cause);
    }

    public String groupName() {
        return this.groupName;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return this.errorPrefix + "-" + this.groupName() + "-" + this.errorCode();
    }

    public short groupCode() {
        return ErrorGroups.extractGroupCode((int)this.code);
    }

    public short errorCode() {
        return ErrorGroup.extractErrorCode((int)this.code);
    }

    public UUID traceId() {
        return this.traceId;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + ErrorGroupHelper.errorMessage(this.errorPrefix, this.traceId, this.groupName, this.code, this.getLocalizedMessage());
    }
}

