/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.util.IteratorCursor;

public interface Cursor<T>
extends Iterator<T>,
Iterable<T>,
AutoCloseable {
    @Override
    default public Iterator<T> iterator() {
        return this;
    }

    public static <T> Cursor<T> fromBareIterator(Iterator<? extends T> it) {
        if (it instanceof AutoCloseable) {
            throw new IllegalArgumentException(it.getClass().getName() + " implements AutoCloseable, while Cursor#fromBareIterator() only supports non-closeable iterators. Please refer to Cursor#fromCloseableIterator().");
        }
        return new IteratorCursor<T>(it){

            @Override
            public void close() {
            }
        };
    }

    public static <T> Cursor<T> fromIterable(Iterable<? extends T> iterable) {
        return Cursor.fromBareIterator(iterable.iterator());
    }

    public static <T, I extends Iterator<? extends T> & AutoCloseable> Cursor<T> fromCloseableIterator(final I iterator) {
        return new IteratorCursor<T>(iterator){

            @Override
            public void close() {
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception e) {
                    throw new IgniteInternalException(e);
                }
            }
        };
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public void close();
}

