/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyRequestOptions;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.exceptions.ContentLengthExceededException;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.exceptions.NoHostException;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.filter.DefaultHttpClientFilterResolver;
import io.micronaut.http.client.filters.ClientServerContextFilter;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.client.multipart.MultipartDataFactory;
import io.micronaut.http.client.netty.CompositeNettyClientCustomizer;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.ForwardingSubscriber;
import io.micronaut.http.client.netty.FullNettyClientHttpResponse;
import io.micronaut.http.client.netty.MicronautFlux;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.NettyClientHttpRequest;
import io.micronaut.http.client.netty.NettyFuturePublisher;
import io.micronaut.http.client.netty.NettyPromiseSubscriber;
import io.micronaut.http.client.netty.NettyStreamedHttpResponse;
import io.micronaut.http.client.netty.SimpleChannelInboundHandlerInstrumented;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.netty.websocket.NettyWebSocketClientHandler;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.http.util.HttpHeadersUtil;
import io.micronaut.jackson.databind.JacksonDatabindMapper;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.JsonStreamMediaTypeCodec;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@Internal
public class DefaultHttpClient
implements WebSocketClient,
HttpClient,
StreamingHttpClient,
SseClient,
ProxyHttpClient,
Closeable,
AutoCloseable {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final HttpHeaders REDIRECT_HEADER_BLOCKLIST = new DefaultHttpHeaders();
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory = new NettyByteBufferFactory();
    final ConnectionManager connectionManager;
    private final List<HttpFilterResolver.FilterEntry<HttpClientFilter>> clientFilterEntries;
    private final LoadBalancer loadBalancer;
    private final HttpClientConfiguration configuration;
    private final String contextPath;
    private final Charset defaultCharset;
    private final Logger log;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver;
    private final WebSocketBeanRegistry webSocketRegistry;
    private final RequestBinderRegistry requestBinderRegistry;
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;
    private final String informationalServiceId;

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<InvocationInstrumenterFactory> invocationInstrumenterFactories, HttpClientFilter ... filters) {
        this(loadBalancer, configuration.getHttpVersion(), configuration, contextPath, (HttpClientFilterResolver<ClientFilterResolutionContext>)new DefaultHttpClientFilterResolver(annotationMetadataResolver, Arrays.asList(filters)), null, threadFactory, nettyClientSslBuilder, codecRegistry, WebSocketBeanRegistry.EMPTY, (RequestBinderRegistry)new DefaultRequestBinderRegistry(ConversionService.SHARED, new RequestArgumentBinder[0]), null, NioSocketChannel::new, Collections.emptySet(), CompositeNettyClientCustomizer.EMPTY, invocationInstrumenterFactories, null);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @Nullable HttpVersion explicitHttpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @NonNull HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver, List<HttpFilterResolver.FilterEntry<HttpClientFilter>> clientFilterEntries, @Nullable ThreadFactory threadFactory, @NonNull NettyClientSslBuilder nettyClientSslBuilder, @NonNull MediaTypeCodecRegistry codecRegistry, @NonNull WebSocketBeanRegistry webSocketBeanRegistry, @NonNull RequestBinderRegistry requestBinderRegistry, @Nullable EventLoopGroup eventLoopGroup, @NonNull ChannelFactory socketChannelFactory, Collection<ChannelPipelineListener> pipelineListeners, NettyClientCustomizer clientCustomizer, List<InvocationInstrumenterFactory> invocationInstrumenterFactories, @Nullable String informationalServiceId) {
        ArgumentUtils.requireNonNull((String)"nettyClientSslBuilder", (Object)((Object)nettyClientSslBuilder));
        ArgumentUtils.requireNonNull((String)"codecRegistry", (Object)codecRegistry);
        ArgumentUtils.requireNonNull((String)"webSocketBeanRegistry", (Object)webSocketBeanRegistry);
        ArgumentUtils.requireNonNull((String)"requestBinderRegistry", (Object)requestBinderRegistry);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"filterResolver", filterResolver);
        ArgumentUtils.requireNonNull((String)"socketChannelFactory", (Object)socketChannelFactory);
        this.loadBalancer = loadBalancer;
        this.defaultCharset = configuration.getDefaultCharset();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (contextPath.charAt(0) != '/') {
                contextPath = '/' + contextPath;
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
        this.configuration = configuration;
        this.invocationInstrumenterFactories = invocationInstrumenterFactories == null ? Collections.emptyList() : invocationInstrumenterFactories;
        this.mediaTypeCodecRegistry = codecRegistry;
        this.log = configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(DEFAULT_LOG);
        this.filterResolver = filterResolver;
        this.clientFilterEntries = clientFilterEntries != null ? clientFilterEntries : filterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(null, AnnotationMetadata.EMPTY_METADATA));
        this.webSocketRegistry = webSocketBeanRegistry != null ? webSocketBeanRegistry : WebSocketBeanRegistry.EMPTY;
        this.requestBinderRegistry = requestBinderRegistry;
        this.informationalServiceId = informationalServiceId;
        this.connectionManager = new ConnectionManager(this.log, eventLoopGroup, threadFactory, configuration, explicitHttpVersion, this.combineFactories(), (ChannelFactory<? extends Channel>)socketChannelFactory, nettyClientSslBuilder, clientCustomizer, pipelineListeners, informationalServiceId);
    }

    public DefaultHttpClient(@Nullable URI uri) {
        this(uri, (HttpClientConfiguration)new DefaultHttpClientConfiguration());
    }

    public DefaultHttpClient() {
        this(null, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), Collections.emptyList());
    }

    public DefaultHttpClient(@Nullable URI uri, @NonNull HttpClientConfiguration configuration) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, Collections.emptyList(), new HttpClientFilter[0]);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, HttpClientConfiguration configuration, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this(loadBalancer, configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, invocationInstrumenterFactories, new HttpClientFilter[0]);
    }

    static boolean isAcceptEvents(HttpRequest<?> request) {
        String acceptHeader = (String)request.getHeaders().get((CharSequence)"Accept");
        return acceptHeader != null && acceptHeader.equalsIgnoreCase("text/event-stream");
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Logger getLog() {
        return this.log;
    }

    public HttpClient start() {
        if (!this.isRunning()) {
            this.connectionManager.start();
        }
        return this;
    }

    public boolean isRunning() {
        return this.connectionManager.isRunning();
    }

    public HttpClient stop() {
        if (this.isRunning()) {
            this.connectionManager.shutdown();
        }
        return this;
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (mediaTypeCodecRegistry != null) {
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }
    }

    public BlockingHttpClient toBlocking() {
        return new BlockingHttpClient(){

            public void close() {
                DefaultHttpClient.this.close();
            }

            public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                Flux publisher = Flux.from(DefaultHttpClient.this.exchange(request, bodyType, errorType));
                return (HttpResponse)publisher.doOnNext(res -> {
                    Optional byteBuf = res.getBody(ByteBuf.class);
                    byteBuf.ifPresent(bb -> {
                        if (bb.refCnt() > 0) {
                            ReferenceCountUtil.safeRelease((Object)bb);
                        }
                    });
                    if (res instanceof FullNettyClientHttpResponse) {
                        ((FullNettyClientHttpResponse)res).onComplete();
                    }
                }).blockFirst();
            }

            public <I, O, E> O retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                HttpResponse response = this.exchange(request, bodyType, errorType);
                if (HttpStatus.class.isAssignableFrom(bodyType.getType())) {
                    return (O)response.getStatus();
                }
                Optional body = response.getBody();
                if (!body.isPresent() && response.getBody(Argument.of(byte[].class)).isPresent()) {
                    throw (HttpClientResponseException)((Object)DefaultHttpClient.this.customizeException((HttpClientException)((Object)new HttpClientResponseException(String.format("Failed to decode the body for the given content type [%s]", response.getContentType().orElse(null)), response))));
                }
                return (O)body.orElseThrow(() -> (HttpClientResponseException)((Object)((Object)((Object)DefaultHttpClient.this.customizeException((HttpClientException)((Object)((Object)((Object)new HttpClientResponseException("Empty body", response)))))))));
            }
        };
    }

    public <I> Publisher<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> request) {
        return this.eventStreamOrError(request, null);
    }

    private <I> Publisher<Event<ByteBuffer<?>>> eventStreamOrError(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM_TYPE});
        }
        return Flux.create(emitter -> this.dataStream(request, errorType).subscribe(new Subscriber<ByteBuffer<?>>((FluxSink)emitter){
            private Subscription dataSubscription;
            private CurrentEvent currentEvent;
            final /* synthetic */ FluxSink val$emitter;
            {
                this.val$emitter = fluxSink;
            }

            public void onSubscribe(Subscription s) {
                this.dataSubscription = s;
                Disposable cancellable = () -> this.dataSubscription.cancel();
                this.val$emitter.onCancel(cancellable);
                if (!this.val$emitter.isCancelled() && this.val$emitter.requestedFromDownstream() > 0L) {
                    this.dataSubscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer<?> buffer) {
                try {
                    int len = buffer.readableBytes();
                    if (len == 0) {
                        try {
                            Event event = Event.of((Object)DefaultHttpClient.this.byteBufferFactory.wrap(this.currentEvent.data)).name(this.currentEvent.name).retry(this.currentEvent.retry).id(this.currentEvent.id);
                            this.val$emitter.next((Object)event);
                        }
                        finally {
                            this.currentEvent = null;
                        }
                    } else {
                        int colonIndex;
                        if (this.currentEvent == null) {
                            this.currentEvent = new CurrentEvent();
                        }
                        if ((colonIndex = buffer.indexOf((byte)58)) > 0) {
                            String type = buffer.slice(0, colonIndex).toString(StandardCharsets.UTF_8).trim();
                            int fromIndex = colonIndex + 1;
                            if (buffer.getByte(fromIndex) == 32) {
                                ++fromIndex;
                            }
                            if (fromIndex < len) {
                                int toIndex = len - fromIndex;
                                switch (type) {
                                    case "data": {
                                        ByteBuffer content = buffer.slice(fromIndex, toIndex);
                                        byte[] d = this.currentEvent.data;
                                        if (d == null) {
                                            this.currentEvent.data = content.toByteArray();
                                            break;
                                        }
                                        this.currentEvent.data = ArrayUtils.concat((byte[])d, (byte[])content.toByteArray());
                                        break;
                                    }
                                    case "id": {
                                        ByteBuffer id = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.id = id.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "event": {
                                        ByteBuffer event = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.name = event.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "retry": {
                                        ByteBuffer retry = buffer.slice(fromIndex, toIndex);
                                        String text = retry.toString(StandardCharsets.UTF_8);
                                        if (StringUtils.isEmpty((CharSequence)text)) break;
                                        Long millis = Long.valueOf(text);
                                        this.currentEvent.retry = Duration.ofMillis(millis);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (this.val$emitter.requestedFromDownstream() > 0L && !this.val$emitter.isCancelled()) {
                        this.dataSubscription.request(1L);
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                finally {
                    if (buffer instanceof ReferenceCounted) {
                        ((ReferenceCounted)buffer).release();
                    }
                }
            }

            public void onError(Throwable t) {
                this.dataSubscription.cancel();
                if (t instanceof HttpClientException) {
                    this.val$emitter.error(t);
                } else {
                    this.val$emitter.error((Throwable)DefaultHttpClient.this.customizeException(new HttpClientException("Error consuming Server Sent Events: " + t.getMessage(), t)));
                }
            }

            public void onComplete() {
                this.val$emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType) {
        return this.eventStream(request, eventType, DEFAULT_ERROR_TYPE);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType, @NonNull Argument<?> errorType) {
        return Flux.from(this.eventStreamOrError(request, errorType)).map(byteBufferEvent -> {
            ByteBuffer data = (ByteBuffer)byteBufferEvent.getData();
            Optional registeredCodec = this.mediaTypeCodecRegistry != null ? this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE) : Optional.empty();
            if (registeredCodec.isPresent()) {
                Object decoded = ((MediaTypeCodec)registeredCodec.get()).decode(eventType, data);
                return Event.of((Event)byteBufferEvent, (Object)decoded);
            }
            throw new CodecException("JSON codec not present");
        });
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        return this.dataStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<ByteBuffer>(Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.dataStreamImpl(request, errorType, (HttpRequest<Object>)parentRequest, (URI)requestURI))).doAfterNext(buffer -> {
            ByteBuf byteBuf;
            Object o = buffer.asNativeBuffer();
            if (o instanceof ByteBuf && (byteBuf = (ByteBuf)o).refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        });
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return this.exchangeStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<HttpResponse>(Flux.from(this.resolveRequestURI(request)).flatMap(uri -> this.exchangeStreamImpl((HttpRequest<Object>)parentRequest, request, errorType, (URI)uri))).doAfterNext(byteBufferHttpResponse -> {
            ByteBuffer buffer = (ByteBuffer)byteBufferHttpResponse.body();
            if (buffer instanceof ReferenceCounted) {
                ((ReferenceCounted)buffer).release();
            }
        });
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return this.jsonStream(request, type, DEFAULT_ERROR_TYPE);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.jsonStreamImpl((HttpRequest<?>)parentRequest, request, type, errorType, (URI)requestURI));
    }

    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return this.jsonStream(request, Map.class);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return this.jsonStream(request, Argument.of(type));
    }

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        Publisher<URI> uriPublisher = this.resolveRequestURI(request);
        return Flux.from(uriPublisher).switchMap(uri -> this.exchangeImpl((URI)uri, (HttpRequest<?>)parentRequest, request, bodyType, errorType));
    }

    public <I, O, E> Publisher<O> retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        Flux exchange = Flux.from(this.exchange(request, bodyType, errorType));
        if (bodyType.getType() == Void.TYPE) {
            return exchange.ignoreElements();
        }
        return exchange.map(response -> {
            if (bodyType.getType() == HttpStatus.class) {
                return response.getStatus();
            }
            Optional body = response.getBody();
            if (!body.isPresent() && response.getBody(byte[].class).isPresent()) {
                throw this.customizeException(new HttpClientResponseException(String.format("Failed to decode the body for the given content type [%s]", response.getContentType().orElse(null)), response));
            }
            return body.orElseThrow(() -> this.customizeException(new HttpClientResponseException("Empty body", response)));
        });
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, request, clientEndpointType, null));
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        WebSocketBean webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        String uri = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("/ws");
        uri = UriTemplate.of((String)uri).expand(parameters);
        MutableHttpRequest request = HttpRequest.GET((String)uri);
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, (MutableHttpRequest<?>)request, clientEndpointType, (WebSocketBean)webSocketBean));
    }

    @Override
    public void close() {
        this.stop();
    }

    private <T> Publisher<T> connectWebSocket(URI uri, MutableHttpRequest<?> request, Class<T> clientEndpointType, WebSocketBean<T> webSocketBean) {
        RequestKey requestKey;
        try {
            requestKey = new RequestKey(this, uri);
        }
        catch (HttpClientException e) {
            return Flux.error((Throwable)e);
        }
        if (webSocketBean == null) {
            webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        }
        WebSocketVersion protocolVersion = webSocketBean.getBeanDefinition().enumValue(ClientWebSocket.class, "version", WebSocketVersion.class).orElse(WebSocketVersion.V13);
        int maxFramePayloadLength = webSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
        String subprotocol = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class, "subprotocol").orElse("");
        URI webSocketURL = UriBuilder.of((URI)uri).scheme(!requestKey.isSecure() ? "ws" : "wss").host(requestKey.getHost()).port(requestKey.getPort()).build();
        MutableHttpHeaders headers = request.getHeaders();
        EmptyHttpHeaders customHeaders = EmptyHttpHeaders.INSTANCE;
        if (headers instanceof NettyHttpHeaders) {
            customHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
        }
        if (StringUtils.isNotEmpty((CharSequence)subprotocol)) {
            customHeaders.add("Sec-WebSocket-Protocol", (Object)subprotocol);
        }
        NettyWebSocketClientHandler handler = new NettyWebSocketClientHandler(request, webSocketBean, WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURL, (WebSocketVersion)protocolVersion, (String)subprotocol, (boolean)true, (HttpHeaders)customHeaders, (int)maxFramePayloadLength), this.requestBinderRegistry, this.mediaTypeCodecRegistry);
        return this.connectionManager.connectForWebsocket(requestKey, (ChannelHandler)handler).then(handler.getHandshakeCompletedMono());
    }

    private <I> Flux<HttpResponse<ByteBuffer<?>>> exchangeStreamImpl(HttpRequest<Object> parentRequest, HttpRequest<I> request, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            StreamedHttpResponse streamedHttpResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamedHttpResponse);
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(message -> {
                ByteBuf byteBuf = message.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{byteBuf.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Response", byteBuf);
                }
                ByteBuffer byteBuffer = this.byteBufferFactory.wrap((Object)byteBuf);
                NettyStreamedHttpResponse<ByteBuffer> thisResponse = new NettyStreamedHttpResponse<ByteBuffer>(streamedHttpResponse, response.status());
                thisResponse.setBody(byteBuffer);
                return new HttpResponseWrapper(thisResponse);
            });
        }).doOnTerminate(() -> {
            Channel c;
            Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
            if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                c.close();
            }
        });
    }

    private <I, O> Flux<O> jsonStreamImpl(HttpRequest<?> parentRequest, HttpRequest<I> request, Argument<O> type, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            MapperMediaTypeCodec mediaTypeCodec = (MapperMediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).orElseThrow(() -> new IllegalStateException("No JSON codec found"));
            StreamedHttpResponse streamResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamResponse);
            boolean isJsonStream = response.getContentType().map(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE)).orElse(false);
            boolean streamArray = !Iterable.class.isAssignableFrom(type.getType()) && !isJsonStream;
            Processor jsonProcessor = mediaTypeCodec.getJsonMapper().createReactiveParser(p -> httpContentReactiveSequence.map(content -> {
                ByteBuf chunk = content.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{chunk.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Chunk", chunk);
                }
                try {
                    byte[] byArray = ByteBufUtil.getBytes((ByteBuf)chunk);
                    return byArray;
                }
                finally {
                    chunk.release();
                }
            }).subscribe((Subscriber)p), streamArray);
            return Flux.from((Publisher)jsonProcessor).map(jsonNode -> mediaTypeCodec.decode(type, jsonNode));
        }).doOnTerminate(() -> {
            Channel c;
            Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
            if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                c.close();
            }
        });
    }

    private <I> Flux<ByteBuffer<?>> dataStreamImpl(HttpRequest<I> request, Argument<?> errorType, HttpRequest<Object> parentRequest, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        Function<HttpContent, ByteBuffer> contentMapper = message -> {
            ByteBuf byteBuf = message.content();
            return this.byteBufferFactory.wrap((Object)byteBuf);
        };
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
            Flux httpContentReactiveSequence = Flux.from((Publisher)nettyStreamedHttpResponse.getNettyResponse());
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(contentMapper);
        }).doOnTerminate(() -> {
            Channel c;
            Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
            if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                c.close();
            }
        });
    }

    private <I> Publisher<MutableHttpResponse<Object>> buildStreamExchange(@Nullable HttpRequest<?> parentRequest, @NonNull HttpRequest<I> request, @NonNull URI requestURI, @Nullable Argument<?> errorType) {
        AtomicReference requestWrapper = new AtomicReference(request);
        Flux streamResponsePublisher = this.connectAndStream(parentRequest, request, requestURI, requestWrapper, false, true);
        streamResponsePublisher = this.readBodyOnError(errorType, streamResponsePublisher);
        streamResponsePublisher = Flux.from(this.applyFilterToResponsePublisher(parentRequest, request, requestURI, requestWrapper, (Publisher)streamResponsePublisher));
        return streamResponsePublisher.subscribeOn(this.connectionManager.getEventLoopScheduler());
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request) {
        return this.proxy(request, ProxyRequestOptions.getDefault());
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request, @NonNull ProxyRequestOptions options) {
        Objects.requireNonNull(options, "options");
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> {
            MutableHttpRequest httpRequest;
            MutableHttpRequest mutableHttpRequest = httpRequest = request instanceof MutableHttpRequest ? (MutableHttpRequest)request : request.mutate();
            if (!options.isRetainHostHeader()) {
                httpRequest.headers(headers -> headers.remove((CharSequence)HttpHeaderNames.HOST));
            }
            AtomicReference<MutableHttpRequest> requestWrapper = new AtomicReference<MutableHttpRequest>(httpRequest);
            Flux proxyResponsePublisher = this.connectAndStream(request, (HttpRequest)request, (URI)requestURI, (AtomicReference<HttpRequest<?>>)requestWrapper, true, false);
            proxyResponsePublisher = Flux.from(this.applyFilterToResponsePublisher(request, (HttpRequest)((HttpRequest)requestWrapper.get()), (URI)requestURI, (AtomicReference<HttpRequest<?>>)requestWrapper, (Publisher)proxyResponsePublisher));
            return proxyResponsePublisher;
        });
    }

    private <I> Flux<MutableHttpResponse<Object>> connectAndStream(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<HttpRequest<?>> requestWrapper, boolean isProxy, boolean failOnError) {
        RequestKey requestKey;
        try {
            requestKey = new RequestKey(this, requestURI);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
        return this.connectionManager.connectForStream(requestKey, isProxy, DefaultHttpClient.isAcceptEvents(request)).flatMapMany(poolHandle -> {
            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)poolHandle.channel);
            return this.streamRequestThroughChannel(parentRequest, (HttpRequest<?>)((HttpRequest)requestWrapper.get()), (ConnectionManager.PoolHandle)poolHandle, failOnError, requestKey.isSecure());
        });
    }

    private <I, O, E> Publisher<? extends HttpResponse<O>> exchangeImpl(URI requestURI, HttpRequest<?> parentRequest, HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        Duration rt;
        RequestKey requestKey;
        AtomicReference requestWrapper = new AtomicReference(request);
        try {
            requestKey = new RequestKey(this, requestURI);
        }
        catch (HttpClientException e) {
            return Flux.error((Throwable)e);
        }
        Mono<ConnectionManager.PoolHandle> handlePublisher = this.connectionManager.connectForExchange(requestKey, MediaType.MULTIPART_FORM_DATA_TYPE.equals(request.getContentType().orElse(null)), DefaultHttpClient.isAcceptEvents(request));
        Flux responsePublisher = handlePublisher.flatMapMany(poolHandle -> Flux.create(emitter -> {
            try {
                this.sendRequestThroughChannel((HttpRequest)((HttpRequest)requestWrapper.get()), bodyType, errorType, (FluxSink)emitter, poolHandle.channel, requestKey.isSecure(), (ConnectionManager.PoolHandle)poolHandle);
            }
            catch (Exception e) {
                emitter.error((Throwable)e);
            }
        }));
        Publisher finalPublisher = this.applyFilterToResponsePublisher(parentRequest, request, requestURI, requestWrapper, (Publisher)responsePublisher);
        Flux finalReactiveSequence = Flux.from(finalPublisher);
        Optional readTimeout = this.configuration.getReadTimeout();
        if (readTimeout.isPresent() && !(rt = (Duration)readTimeout.get()).isNegative()) {
            Duration duration = rt.plus(Duration.ofSeconds(1L));
            finalReactiveSequence = finalReactiveSequence.timeout(duration).onErrorResume(throwable -> {
                if (throwable instanceof TimeoutException) {
                    return Flux.error((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                }
                return Flux.error((Throwable)throwable);
            });
        }
        return finalReactiveSequence;
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request) {
        return this.resolveRequestURI(request, true);
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Flux.just((Object)requestURI);
        }
        return this.resolveURI(request, includeContextPath);
    }

    protected <I> Publisher<URI> resolveRedirectURI(HttpRequest<?> parentRequest, HttpRequest<I> request) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Flux.just((Object)requestURI);
        }
        if (parentRequest == null || parentRequest.getUri().getHost() == null) {
            return this.resolveURI(request, false);
        }
        URI parentURI = parentRequest.getUri();
        UriBuilder uriBuilder = UriBuilder.of((URI)requestURI).scheme(parentURI.getScheme()).userInfo(parentURI.getUserInfo()).host(parentURI.getHost()).port(parentURI.getPort());
        return Flux.just((Object)uriBuilder.build());
    }

    protected URI prependContextPath(URI requestURI) {
        if (StringUtils.isNotEmpty((CharSequence)this.contextPath)) {
            try {
                return new URI(StringUtils.prependUri((String)this.contextPath, (String)requestURI.toString()));
            }
            catch (URISyntaxException e) {
                throw this.customizeException(new HttpClientException("Failed to construct the request URI", (Throwable)e));
            }
        }
        return requestURI;
    }

    protected Object getLoadBalancerDiscriminator() {
        return null;
    }

    private <I, O, R extends HttpResponse<O>> Publisher<R> applyFilterToResponsePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<HttpRequest<?>> requestWrapper, Publisher<R> responsePublisher) {
        if (request instanceof MutableHttpRequest) {
            MutableHttpRequest mutRequest = (MutableHttpRequest)request;
            mutRequest.uri(requestURI);
            if (this.informationalServiceId != null && !mutRequest.getAttribute((CharSequence)HttpAttributes.SERVICE_ID).isPresent()) {
                mutRequest.setAttribute((CharSequence)HttpAttributes.SERVICE_ID, (Object)this.informationalServiceId);
            }
            List filters = this.filterResolver.resolveFilters(request, this.clientFilterEntries);
            if (parentRequest != null) {
                filters.add(new ClientServerContextFilter(parentRequest));
            }
            OrderUtil.reverseSort((List)filters);
            Flux finalResponsePublisher = responsePublisher;
            filters.add((req, chain) -> finalResponsePublisher);
            ClientFilterChain filterChain = this.buildChain(requestWrapper, filters);
            if (parentRequest != null) {
                responsePublisher = (Publisher)ServerRequestContext.with(parentRequest, () -> {
                    try {
                        return Flux.from((Publisher)((HttpClientFilter)filters.get(0)).doFilter(request, (FilterChain)filterChain)).contextWrite(ctx -> ctx.put((Object)"micronaut.http.server.request", (Object)parentRequest));
                    }
                    catch (Throwable t) {
                        return Flux.error((Throwable)t);
                    }
                });
            } else {
                try {
                    responsePublisher = ((HttpClientFilter)filters.get(0)).doFilter(request, (FilterChain)filterChain);
                }
                catch (Throwable t) {
                    responsePublisher = Flux.error((Throwable)t);
                }
            }
        }
        return responsePublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NettyRequestWriter buildNettyRequest(MutableHttpRequest request, URI requestURI, MediaType requestContentType, boolean permitsBody, @Nullable Argument<?> bodyType, Consumer<? super Throwable> onError) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        io.netty.handler.codec.http.HttpRequest nettyRequest;
        HttpPostRequestEncoder postRequestEncoder;
        block20: {
            block21: {
                postRequestEncoder = null;
                if (!permitsBody) break block21;
                Optional body = request.getBody();
                boolean hasBody = body.isPresent();
                if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    if (bodyValue instanceof CharSequence) {
                        ByteBuf byteBuf = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        request.body((Object)byteBuf);
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                        break block20;
                    } else {
                        postRequestEncoder = this.buildFormDataRequest(request, bodyValue);
                        nettyRequest = postRequestEncoder.finalizeRequest();
                    }
                    break block20;
                } else if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    postRequestEncoder = this.buildMultipartRequest(request, bodyValue);
                    nettyRequest = postRequestEncoder.finalizeRequest();
                    break block20;
                } else {
                    ByteBuf bodyContent = null;
                    if (hasBody) {
                        Object bodyValue = body.get();
                        if (Publishers.isConvertibleToPublisher(bodyValue)) {
                            boolean isSingle = Publishers.isSingle(bodyValue.getClass());
                            Publisher publisher = (Publisher)ConversionService.SHARED.convert(bodyValue, Publisher.class).orElseThrow(() -> new IllegalArgumentException("Unconvertible reactive type: " + bodyValue));
                            Flux requestBodyPublisher = Flux.from((Publisher)publisher).map(o -> {
                                Optional registeredCodec;
                                ByteBuf encoded;
                                if (o instanceof CharSequence) {
                                    ByteBuf textChunk = Unpooled.copiedBuffer((CharSequence)((CharSequence)o), (Charset)requestContentType.getCharset().orElse(StandardCharsets.UTF_8));
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(textChunk);
                                    }
                                    return new DefaultHttpContent(textChunk);
                                }
                                if (o instanceof ByteBuf) {
                                    ByteBuf byteBuf = (ByteBuf)o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuf.readableBytes());
                                    }
                                    return new DefaultHttpContent(byteBuf);
                                }
                                if (o instanceof byte[]) {
                                    byte[] bodyBytes = (byte[])o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)bodyBytes.length);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])bodyBytes));
                                }
                                if (o instanceof ByteBuffer) {
                                    ByteBuffer byteBuffer = (ByteBuffer)o;
                                    Object nativeBuffer = byteBuffer.asNativeBuffer();
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuffer.readableBytes());
                                    }
                                    if (nativeBuffer instanceof ByteBuf) {
                                        return new DefaultHttpContent((ByteBuf)nativeBuffer);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])byteBuffer.toByteArray()));
                                }
                                if (this.mediaTypeCodecRegistry != null && (encoded = (ByteBuf)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType)).map(codec -> {
                                    if (bodyType != null && bodyType.isInstance(o)) {
                                        return (ByteBuf)codec.encode(bodyType, o, this.byteBufferFactory).asNativeBuffer();
                                    }
                                    return (ByteBuf)codec.encode(o, this.byteBufferFactory).asNativeBuffer();
                                }).orElse(null)) != null) {
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(encoded);
                                    }
                                    return new DefaultHttpContent(encoded);
                                }
                                throw new CodecException("Cannot encode value [" + o + "]. No possible encoders found");
                            });
                            if (!isSingle && MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContentType)) {
                                requestBodyPublisher = JsonSubscriber.lift((Publisher)requestBodyPublisher);
                            }
                            requestBodyPublisher = requestBodyPublisher.doOnError(onError);
                            request.body((Object)requestBodyPublisher);
                            io.netty.handler.codec.http.HttpRequest nettyRequest2 = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                            try {
                                nettyRequest2.setUri(requestURI.toURL().getFile());
                                return new NettyRequestWriter(nettyRequest2, null);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            return new NettyRequestWriter(nettyRequest2, null);
                        }
                        if (bodyValue instanceof CharSequence) {
                            bodyContent = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        } else if (this.mediaTypeCodecRegistry != null) {
                            Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType);
                            bodyContent = registeredCodec.map(codec -> {
                                if (bodyType != null && bodyType.isInstance(bodyValue)) {
                                    return (ByteBuf)codec.encode(bodyType, bodyValue, this.byteBufferFactory).asNativeBuffer();
                                }
                                return (ByteBuf)codec.encode(bodyValue, this.byteBufferFactory).asNativeBuffer();
                            }).orElse(null);
                        }
                        if (bodyContent == null) {
                            bodyContent = (ByteBuf)ConversionService.SHARED.convert(bodyValue, ByteBuf.class).orElseThrow(() -> this.customizeException(new HttpClientException("Body [" + bodyValue + "] cannot be encoded to content type [" + requestContentType + "]. No possible codecs or converters found.")));
                        }
                    }
                    request.body(bodyContent);
                    try {
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                    }
                    finally {
                        request.body(body.orElse(null));
                    }
                }
            }
            nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
        }
        try {
            nettyRequest.setUri(requestURI.toURL().getFile());
            return new NettyRequestWriter(nettyRequest, postRequestEncoder);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new NettyRequestWriter(nettyRequest, postRequestEncoder);
    }

    private Flux<MutableHttpResponse<Object>> readBodyOnError(final @Nullable Argument<?> errorType, @NonNull Flux<MutableHttpResponse<Object>> publisher) {
        if (errorType != null && errorType != HttpClient.DEFAULT_ERROR_TYPE) {
            return publisher.onErrorResume(clientException -> {
                HttpResponse response;
                if (clientException instanceof HttpClientResponseException && (response = ((HttpClientResponseException)((Object)clientException)).getResponse()) instanceof NettyStreamedHttpResponse) {
                    return Mono.create(emitter -> {
                        NettyStreamedHttpResponse streamedResponse = (NettyStreamedHttpResponse)response;
                        final StreamedHttpResponse nettyResponse = streamedResponse.getNettyResponse();
                        nettyResponse.subscribe((Subscriber)new Subscriber<HttpContent>(){
                            final CompositeByteBuf buffer;
                            Subscription s;
                            {
                                this.buffer = ((ByteBufAllocator)DefaultHttpClient.this.byteBufferFactory.getNativeAllocator()).compositeBuffer();
                            }

                            public void onSubscribe(Subscription s) {
                                this.s = s;
                                s.request(1L);
                            }

                            public void onNext(HttpContent httpContent) {
                                this.buffer.addComponent(true, httpContent.content());
                                this.s.request(1L);
                            }

                            public void onError(Throwable t) {
                                this.buffer.release();
                                emitter.error(t);
                            }

                            public void onComplete() {
                                try {
                                    DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), (ByteBuf)this.buffer, nettyResponse.headers(), (HttpHeaders)new DefaultHttpHeaders(true));
                                    FullNettyClientHttpResponse fullNettyClientHttpResponse = new FullNettyClientHttpResponse((FullHttpResponse)fullHttpResponse, response.status(), DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, errorType, true);
                                    fullNettyClientHttpResponse.onComplete();
                                    emitter.error((Throwable)DefaultHttpClient.this.customizeException((HttpClientException)((Object)new HttpClientResponseException(fullHttpResponse.status().reasonPhrase(), null, fullNettyClientHttpResponse, new HttpClientErrorDecoder(){

                                        public Argument<?> getErrorType(MediaType mediaType) {
                                            return errorType;
                                        }
                                    }))));
                                }
                                finally {
                                    this.buffer.release();
                                }
                            }
                        });
                    });
                }
                return Mono.error((Throwable)clientException);
            });
        }
        return publisher;
    }

    private <I> Publisher<URI> resolveURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (this.loadBalancer == null) {
            return Flux.error((Throwable)this.customizeException(new NoHostException("Request URI specifies no host to connect to")));
        }
        return Flux.from((Publisher)this.loadBalancer.select(this.getLoadBalancerDiscriminator())).map(server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest && authInfo.isPresent()) {
                ((MutableHttpRequest)request).getHeaders().auth((String)authInfo.get());
            }
            return server.resolve(includeContextPath ? this.prependContextPath(requestURI) : requestURI);
        });
    }

    private <I, O, E> void sendRequestThroughChannel(HttpRequest<I> finalRequest, Argument<O> bodyType, Argument<E> errorType, FluxSink<? super HttpResponse<O>> emitter, Channel channel, boolean secure, ConnectionManager.PoolHandle poolHandle) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        URI requestURI = finalRequest.getUri();
        MediaType requestContentType = finalRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)finalRequest.getMethod());
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)finalRequest;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, bodyType, throwable -> {
            if (!emitter.isCancelled()) {
                emitter.error(throwable);
            }
        });
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, finalRequest, nettyRequest, permitsBody, !poolHandle.canReturn());
        if (this.log.isDebugEnabled()) {
            this.debugRequest(requestURI, nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        Promise responsePromise = channel.eventLoop().newPromise();
        channel.pipeline().addLast("micronaut-full-http-response", new FullHttpResponseHandler<O>(responsePromise, poolHandle, secure, finalRequest, bodyType, errorType));
        poolHandle.notifyRequestPipelineBuilt();
        NettyFuturePublisher publisher = new NettyFuturePublisher(responsePromise, true);
        publisher.subscribe(new ForwardingSubscriber<HttpResponse<O>>(emitter));
        requestWriter.write(channel, secure, emitter);
    }

    private Flux<MutableHttpResponse<Object>> streamRequestThroughChannel(HttpRequest<?> parentRequest, HttpRequest<?> request, ConnectionManager.PoolHandle poolHandle, boolean failOnError, boolean secure) {
        return Flux.create(sink -> {
            try {
                this.streamRequestThroughChannel0(parentRequest, request, (FluxSink)sink, poolHandle, secure);
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                sink.error((Throwable)e);
            }
        }).flatMap(resp -> this.handleStreamHttpError(resp, failOnError));
    }

    private <R extends HttpResponse<?>> Flux<R> handleStreamHttpError(R response, boolean failOnError) {
        boolean errorStatus;
        boolean bl = errorStatus = response.code() >= 400;
        if (errorStatus && failOnError) {
            return Flux.error((Throwable)this.customizeException(new HttpClientResponseException(response.getStatus().getReason(), response)));
        }
        return Flux.just(response);
    }

    private void streamRequestThroughChannel0(HttpRequest<?> parentRequest, HttpRequest<?> finalRequest, FluxSink emitter, ConnectionManager.PoolHandle poolHandle, boolean secure) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        NettyRequestWriter requestWriter = this.prepareRequest(finalRequest, finalRequest.getUri(), (FluxSink<HttpResponse<Object>>)emitter);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        Promise responsePromise = poolHandle.channel.eventLoop().newPromise();
        ChannelPipeline pipeline = poolHandle.channel.pipeline();
        pipeline.addLast("micronaut-http-response-full", (ChannelHandler)new StreamFullHttpResponseHandler((Promise<HttpResponse<?>>)responsePromise, parentRequest, finalRequest));
        pipeline.addLast("micronaut-http-response-stream", (ChannelHandler)new StreamStreamHttpResponseHandler((Promise<HttpResponse<?>>)responsePromise, parentRequest, finalRequest));
        poolHandle.notifyRequestPipelineBuilt();
        if (this.log.isDebugEnabled()) {
            this.debugRequest(finalRequest.getUri(), nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        requestWriter.write(poolHandle.channel, secure, emitter);
        responsePromise.addListener(future -> {
            if (future.isSuccess()) {
                emitter.next(future.getNow());
                emitter.complete();
            } else {
                emitter.error(future.cause());
            }
        });
    }

    private ByteBuf charSequenceToByteBuf(CharSequence bodyValue, MediaType requestContentType) {
        CharSequence charSequence = bodyValue;
        return (ByteBuf)this.byteBufferFactory.copiedBuffer(charSequence.toString().getBytes(requestContentType.getCharset().orElse(this.defaultCharset))).asNativeBuffer();
    }

    private String getHostHeader(URI requestURI) {
        RequestKey requestKey = new RequestKey(this, requestURI);
        StringBuilder host = new StringBuilder(requestKey.getHost());
        int port = requestKey.getPort();
        if (port > -1 && port != 80 && port != 443) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private <I> void prepareHttpHeaders(URI requestURI, HttpRequest<I> request, io.netty.handler.codec.http.HttpRequest nettyRequest, boolean permitsBody, boolean closeConnection) {
        HttpHeaders headers = nettyRequest.headers();
        if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)this.getHostHeader(requestURI));
        }
        if (this.connectionManager.httpVersion != HttpVersion.HTTP_2_0) {
            if (closeConnection) {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
        }
        if (permitsBody) {
            Optional body = request.getBody();
            if (body.isPresent()) {
                if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                    MediaType mediaType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                }
                if (nettyRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpRequest.content().readableBytes());
                } else if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
            } else if (!(nettyRequest instanceof StreamedHttpRequest)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            }
        }
    }

    private ClientFilterChain buildChain(final AtomicReference<HttpRequest<?>> requestWrapper, final List<HttpClientFilter> filters) {
        final AtomicInteger integer = new AtomicInteger();
        final int len = filters.size();
        return new ClientFilterChain(){

            public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
                int pos = integer.incrementAndGet();
                if (pos >= len) {
                    throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                }
                HttpClientFilter httpFilter = (HttpClientFilter)filters.get(pos);
                try {
                    return httpFilter.doFilter((HttpRequest)requestWrapper.getAndSet(request), (FilterChain)this);
                }
                catch (Throwable t) {
                    return Flux.error((Throwable)t);
                }
            }
        };
    }

    private HttpPostRequestEncoder buildFormDataRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder(NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest), false);
        Map formData = bodyValue instanceof Map ? (Map)bodyValue : BeanMap.of((Object)bodyValue);
        for (Map.Entry entry : formData.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object val : collection) {
                    this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), val);
                }
                continue;
            }
            this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), value);
        }
        return postRequestEncoder;
    }

    private void addBodyAttribute(HttpPostRequestEncoder postRequestEncoder, String key, Object value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        Optional converted = ConversionService.SHARED.convert(value, String.class);
        if (converted.isPresent()) {
            postRequestEncoder.addBodyAttribute(key, (String)converted.get());
        }
    }

    private HttpPostRequestEncoder buildMultipartRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        io.netty.handler.codec.http.HttpRequest request = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest);
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder((HttpDataFactory)factory, request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        if (bodyValue instanceof MultipartBody.Builder) {
            bodyValue = ((MultipartBody.Builder)bodyValue).build();
        }
        if (!(bodyValue instanceof MultipartBody)) {
            throw new MultipartException(String.format("The type %s is not a supported type for a multipart request body", bodyValue.getClass().getName()));
        }
        MultipartBody multipartBody = (MultipartBody)bodyValue;
        postRequestEncoder.setBodyHttpDatas(multipartBody.getData((MultipartDataFactory)new MultipartDataFactory<InterfaceHttpData>((HttpDataFactory)factory, request){
            final /* synthetic */ HttpDataFactory val$factory;
            final /* synthetic */ io.netty.handler.codec.http.HttpRequest val$request;
            {
                this.val$factory = httpDataFactory;
                this.val$request = httpRequest;
            }

            @NonNull
            public InterfaceHttpData createFileUpload(@NonNull String name, @NonNull String filename, @NonNull MediaType contentType, @Nullable String encoding, @Nullable Charset charset, long length) {
                return this.val$factory.createFileUpload(this.val$request, name, filename, contentType.toString(), encoding, charset, length);
            }

            @NonNull
            public InterfaceHttpData createAttribute(@NonNull String name, @NonNull String value) {
                return this.val$factory.createAttribute(this.val$request, name, value);
            }

            public void setContent(InterfaceHttpData fileUploadObject, Object content) throws IOException {
                if (fileUploadObject instanceof FileUpload) {
                    FileUpload fu = (FileUpload)fileUploadObject;
                    if (content instanceof InputStream) {
                        fu.setContent((InputStream)content);
                    } else if (content instanceof File) {
                        fu.setContent((File)content);
                    } else if (content instanceof byte[]) {
                        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])((byte[])content));
                        fu.setContent(buffer);
                    }
                }
            }
        }));
        return postRequestEncoder;
    }

    private void debugRequest(URI requestURI, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        this.log.debug("Sending HTTP {} to {}", (Object)nettyRequest.method(), (Object)requestURI.toString());
    }

    private void traceRequest(HttpRequest<?> request, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        HttpHeaders headers = nettyRequest.headers();
        HttpHeadersUtil.trace((Logger)this.log, (Set)headers.names(), arg_0 -> ((HttpHeaders)headers).getAll(arg_0));
        if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) && request.getBody().isPresent() && nettyRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
            ByteBuf content = fullHttpRequest.content();
            if (this.log.isTraceEnabled()) {
                this.traceBody("Request", content);
            }
        }
    }

    private void traceBody(String type, ByteBuf content) {
        this.log.trace(type + " Body");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceChunk(ByteBuf content) {
        this.log.trace("Sending Chunk");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        JacksonDatabindMapper mapper = new JacksonDatabindMapper();
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec((JsonMapper)mapper, configuration, null), new JsonStreamMediaTypeCodec((JsonMapper)mapper, configuration, null)});
    }

    private <I> NettyRequestWriter prepareRequest(HttpRequest<I> request, URI requestURI, FluxSink<HttpResponse<Object>> emitter) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        MediaType requestContentType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        if (!(request instanceof MutableHttpRequest)) {
            throw new IllegalArgumentException("A MutableHttpRequest is required");
        }
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)request;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, null, throwable -> {
            if (!emitter.isCancelled()) {
                emitter.error(throwable);
            }
        });
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, request, nettyRequest, permitsBody, true);
        return requestWriter;
    }

    @NonNull
    private InvocationInstrumenter combineFactories() {
        if (CollectionUtils.isEmpty(this.invocationInstrumenterFactories)) {
            return InvocationInstrumenter.NOOP;
        }
        return InvocationInstrumenter.combine((Collection)this.invocationInstrumenterFactories.stream().map(InvocationInstrumenterFactory::newInvocationInstrumenter).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    static boolean isSecureScheme(String scheme) {
        return "https".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }

    private <E extends HttpClientException> E customizeException(E exc) {
        DefaultHttpClient.customizeException0(this.configuration, this.informationalServiceId, exc);
        return exc;
    }

    static void customizeException0(HttpClientConfiguration configuration, String informationalServiceId, HttpClientException exc) {
        if (informationalServiceId != null) {
            exc.setServiceId(informationalServiceId);
        } else if (configuration instanceof ServiceHttpClientConfiguration) {
            exc.setServiceId(((ServiceHttpClientConfiguration)configuration).getServiceId());
        }
    }

    static {
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.HOST, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"");
    }

    private class StreamStreamHttpResponseHandler
    extends BaseHttpResponseHandler<StreamedHttpResponse, HttpResponse<?>> {
        public StreamStreamHttpResponseHandler(Promise<HttpResponse<?>> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(responsePromise, parentRequest, finalRequest);
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof StreamedHttpResponse;
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<?>> promise, StreamedHttpResponse msg, HttpStatus httpStatus) {
            promise.trySuccess(new NettyStreamedHttpResponse(msg, httpStatus));
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<?>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.buildStreamExchange(parentRequest, (HttpRequest)redirectRequest, uri, null);
        }
    }

    private class StreamFullHttpResponseHandler
    extends BaseHttpResponseHandler<FullHttpResponse, HttpResponse<?>> {
        public StreamFullHttpResponseHandler(Promise<HttpResponse<?>> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(responsePromise, parentRequest, finalRequest);
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof FullHttpResponse;
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<?>> promise, FullHttpResponse msg, HttpStatus httpStatus) {
            Publisher bodyPublisher = msg.content() instanceof EmptyByteBuf ? Publishers.empty() : Publishers.just((Object)new DefaultLastHttpContent(msg.content()));
            DefaultStreamedHttpResponse nettyResponse = new DefaultStreamedHttpResponse(msg.protocolVersion(), msg.status(), msg.headers(), bodyPublisher);
            promise.trySuccess(new NettyStreamedHttpResponse((StreamedHttpResponse)nettyResponse, httpStatus));
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<?>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.buildStreamExchange(parentRequest, (HttpRequest)redirectRequest, uri, null);
        }
    }

    private class FullHttpResponseHandler<O>
    extends BaseHttpResponseHandler<FullHttpResponse, HttpResponse<O>> {
        private final boolean secure;
        private final Argument<O> bodyType;
        private final Argument<?> errorType;
        private final ConnectionManager.PoolHandle poolHandle;

        public FullHttpResponseHandler(Promise<HttpResponse<O>> responsePromise, ConnectionManager.PoolHandle poolHandle, boolean secure, HttpRequest<?> request, Argument<O> bodyType, Argument<?> errorType) {
            super(responsePromise, request, request);
            this.secure = secure;
            this.bodyType = bodyType;
            this.errorType = errorType;
            this.poolHandle = poolHandle;
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof FullHttpResponse;
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<O>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.exchangeImpl(uri, parentRequest, (HttpRequest)redirectRequest, this.bodyType, this.errorType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void channelReadInstrumented(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullResponse) throws Exception {
            try {
                fullResponse.retain();
                super.channelReadInstrumented(channelHandlerContext, fullResponse);
            }
            finally {
                block10: {
                    if (fullResponse.refCnt() > 1) {
                        try {
                            ReferenceCountUtil.release((Object)fullResponse);
                        }
                        catch (Exception e) {
                            if (!DefaultHttpClient.this.log.isDebugEnabled()) break block10;
                            DefaultHttpClient.this.log.debug("Failed to release response: {}", (Object)fullResponse);
                        }
                    }
                }
                if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                    this.poolHandle.taint();
                }
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
            }
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<O>> promise, FullHttpResponse msg, HttpStatus httpStatus) {
            try {
                if (DefaultHttpClient.this.log.isTraceEnabled()) {
                    DefaultHttpClient.this.traceBody("Response", msg.content());
                }
                if (httpStatus == HttpStatus.NO_CONTENT) {
                    msg.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                }
                boolean convertBodyWithBodyType = httpStatus.getCode() < 400 || !DefaultHttpClient.this.configuration.isExceptionOnErrorStatus() && this.bodyType.equalsType(this.errorType);
                FullNettyClientHttpResponse<O> response = new FullNettyClientHttpResponse<O>(msg, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, this.bodyType, convertBodyWithBodyType);
                if (convertBodyWithBodyType) {
                    promise.trySuccess(response);
                    response.onComplete();
                } else {
                    try {
                        promise.tryFailure((Throwable)this.makeErrorFromRequestBody(msg.status(), response));
                        response.onComplete();
                    }
                    catch (HttpClientResponseException t) {
                        promise.tryFailure((Throwable)t);
                        response.onComplete();
                    }
                    catch (Exception t) {
                        response.onComplete();
                        promise.tryFailure((Throwable)this.makeErrorBodyParseError(msg, httpStatus, t));
                    }
                }
            }
            catch (HttpClientResponseException t) {
                promise.tryFailure((Throwable)t);
            }
            catch (Exception t) {
                this.makeNormalBodyParseError(msg, httpStatus, t, cause -> {
                    if (!promise.tryFailure((Throwable)cause) && DefaultHttpClient.this.log.isWarnEnabled()) {
                        DefaultHttpClient.this.log.warn("Exception fired after handler completed: " + t.getMessage(), (Throwable)t);
                    }
                });
            }
        }

        private HttpClientResponseException makeErrorFromRequestBody(HttpResponseStatus status, FullNettyClientHttpResponse<?> response) {
            if (this.errorType != null && this.errorType != HttpClient.DEFAULT_ERROR_TYPE) {
                return (HttpClientResponseException)((Object)DefaultHttpClient.this.customizeException((HttpClientException)((Object)new HttpClientResponseException(status.reasonPhrase(), null, response, new HttpClientErrorDecoder(){

                    public Argument<?> getErrorType(MediaType mediaType) {
                        return FullHttpResponseHandler.this.errorType;
                    }
                }))));
            }
            return (HttpClientResponseException)((Object)DefaultHttpClient.this.customizeException((HttpClientException)((Object)new HttpClientResponseException(status.reasonPhrase(), response))));
        }

        private HttpClientResponseException makeErrorBodyParseError(FullHttpResponse fullResponse, HttpStatus httpStatus, Throwable t) {
            FullNettyClientHttpResponse errorResponse = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false);
            errorResponse.onComplete();
            return (HttpClientResponseException)((Object)DefaultHttpClient.this.customizeException((HttpClientException)((Object)new HttpClientResponseException("Error decoding HTTP error response body: " + t.getMessage(), t, errorResponse, null))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeNormalBodyParseError(FullHttpResponse fullResponse, HttpStatus httpStatus, Throwable t, Consumer<HttpClientResponseException> forward) {
            FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false);
            HttpClientResponseException clientResponseError = (HttpClientResponseException)((Object)DefaultHttpClient.this.customizeException((HttpClientException)((Object)new HttpClientResponseException("Error decoding HTTP response body: " + t.getMessage(), t, response, new HttpClientErrorDecoder(){

                public Argument<?> getErrorType(MediaType mediaType) {
                    return FullHttpResponseHandler.this.errorType;
                }
            }))));
            try {
                forward.accept(clientResponseError);
            }
            finally {
                response.onComplete();
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.poolHandle.release();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            super.exceptionCaught(ctx, cause);
            this.poolHandle.taint();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private abstract class BaseHttpResponseHandler<R extends io.netty.handler.codec.http.HttpResponse, O>
    extends SimpleChannelInboundHandlerInstrumented<R> {
        private final Promise<O> responsePromise;
        private final HttpRequest<?> parentRequest;
        private final HttpRequest<?> finalRequest;

        public BaseHttpResponseHandler(Promise<O> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(DefaultHttpClient.this.connectionManager.instrumenter);
            this.responsePromise = responsePromise;
            this.parentRequest = parentRequest;
            this.finalRequest = finalRequest;
        }

        public abstract boolean acceptInboundMessage(Object var1);

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String message = cause.getMessage();
            if (message == null) {
                message = cause.getClass().getSimpleName();
            }
            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                DefaultHttpClient.this.log.trace("HTTP Client exception ({}) occurred for request : {} {}", new Object[]{message, this.finalRequest.getMethodName(), this.finalRequest.getUri()});
            }
            Object result = cause instanceof TooLongFrameException ? DefaultHttpClient.this.customizeException((HttpClientException)new ContentLengthExceededException((long)DefaultHttpClient.this.configuration.getMaxContentLength())) : (cause instanceof io.netty.handler.timeout.ReadTimeoutException ? ReadTimeoutException.TIMEOUT_EXCEPTION : DefaultHttpClient.this.customizeException(new HttpClientException("Error occurred reading HTTP response: " + message, cause)));
            this.responsePromise.tryFailure((Throwable)result);
        }

        @Override
        protected void channelReadInstrumented(ChannelHandlerContext ctx, R msg) throws Exception {
            HttpStatus httpStatus;
            if (this.responsePromise.isDone()) {
                return;
            }
            if (DefaultHttpClient.this.log.isDebugEnabled()) {
                DefaultHttpClient.this.log.debug("Received response {} from {}", (Object)msg.status().code(), (Object)this.finalRequest.getUri());
            }
            int code = msg.status().code();
            HttpHeaders headers1 = msg.headers();
            if (code > 300 && code < 400 && DefaultHttpClient.this.configuration.isFollowRedirects() && headers1.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                MutableHttpRequest redirectRequest;
                String location = headers1.get((CharSequence)HttpHeaderNames.LOCATION);
                if (code == 307) {
                    redirectRequest = HttpRequest.create((HttpMethod)this.finalRequest.getMethod(), (String)location);
                    this.finalRequest.getBody().ifPresent(arg_0 -> ((MutableHttpRequest)redirectRequest).body(arg_0));
                } else {
                    redirectRequest = HttpRequest.GET((String)location);
                }
                this.setRedirectHeaders(this.finalRequest, (MutableHttpRequest<Object>)redirectRequest);
                Flux.from(DefaultHttpClient.this.resolveRedirectURI(this.parentRequest, redirectRequest)).flatMap(this.makeRedirectHandler(this.parentRequest, (MutableHttpRequest<Object>)redirectRequest)).subscribe(new NettyPromiseSubscriber<O>(this.responsePromise));
                return;
            }
            HttpResponseStatus status = msg.status();
            int statusCode = status.code();
            try {
                httpStatus = HttpStatus.valueOf((int)statusCode);
            }
            catch (IllegalArgumentException e) {
                this.responsePromise.tryFailure((Throwable)e);
                return;
            }
            HttpHeaders headers = msg.headers();
            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                DefaultHttpClient.this.log.trace("HTTP Client Response Received ({}) for Request: {} {}", new Object[]{msg.status(), this.finalRequest.getMethodName(), this.finalRequest.getUri()});
                HttpHeadersUtil.trace((Logger)DefaultHttpClient.this.log, (Set)headers.names(), arg_0 -> ((HttpHeaders)headers).getAll(arg_0));
            }
            this.buildResponse(this.responsePromise, msg, httpStatus);
        }

        private void setRedirectHeaders(@Nullable HttpRequest<?> request, MutableHttpRequest<Object> redirectRequest) {
            if (request != null) {
                for (Map.Entry originalHeader : request.getHeaders()) {
                    List originalHeaderValue;
                    if (REDIRECT_HEADER_BLOCKLIST.contains((String)originalHeader.getKey()) || (originalHeaderValue = (List)originalHeader.getValue()) == null || originalHeaderValue.isEmpty()) continue;
                    for (String value : originalHeaderValue) {
                        if (value == null) continue;
                        redirectRequest.header((CharSequence)originalHeader.getKey(), (CharSequence)value);
                    }
                }
            }
        }

        protected abstract Function<URI, Publisher<? extends O>> makeRedirectHandler(HttpRequest<?> var1, MutableHttpRequest<Object> var2);

        protected abstract void buildResponse(Promise<? super O> var1, R var2, HttpStatus var3);
    }

    private static class CurrentEvent {
        byte[] data;
        String id;
        String name;
        Duration retry;

        private CurrentEvent() {
        }
    }

    private class NettyRequestWriter {
        private final io.netty.handler.codec.http.HttpRequest nettyRequest;
        private final HttpPostRequestEncoder encoder;

        NettyRequestWriter(io.netty.handler.codec.http.HttpRequest nettyRequest, HttpPostRequestEncoder encoder) {
            this.nettyRequest = nettyRequest;
            this.encoder = encoder;
        }

        protected void write(Channel channel, boolean isSecure, FluxSink<?> emitter) {
            ChannelPipeline pipeline = channel.pipeline();
            if (DefaultHttpClient.this.connectionManager.httpVersion == HttpVersion.HTTP_2_0) {
                if (isSecure) {
                    this.nettyRequest.headers().add((CharSequence)AbstractNettyHttpRequest.HTTP2_SCHEME, (Object)HttpScheme.HTTPS);
                } else {
                    this.nettyRequest.headers().add((CharSequence)AbstractNettyHttpRequest.HTTP2_SCHEME, (Object)HttpScheme.HTTP);
                }
            }
            this.processRequestWrite(channel, emitter, pipeline);
        }

        private void processRequestWrite(Channel channel, FluxSink<?> emitter, ChannelPipeline pipeline) {
            ChannelFuture writeFuture;
            if (this.encoder != null && this.encoder.isChunked()) {
                channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set((Object)true);
                pipeline.addAfter("http-streams-codec", "chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
                channel.write((Object)this.nettyRequest);
                writeFuture = channel.writeAndFlush((Object)this.encoder);
            } else {
                writeFuture = channel.writeAndFlush((Object)this.nettyRequest);
            }
            DefaultHttpClient.this.connectionManager.addInstrumentedListener(writeFuture, f -> {
                try {
                    if (!f.isSuccess()) {
                        if (!emitter.isCancelled()) {
                            emitter.error(f.cause());
                        }
                    } else {
                        channel.read();
                    }
                }
                finally {
                    if (this.encoder != null) {
                        this.encoder.cleanFiles();
                    }
                    channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set(null);
                }
            });
        }

        io.netty.handler.codec.http.HttpRequest getNettyRequest() {
            return this.nettyRequest;
        }
    }

    static final class RequestKey {
        private final String host;
        private final int port;
        private final boolean secure;

        public RequestKey(DefaultHttpClient ctx, URI requestURI) {
            int port;
            this.secure = DefaultHttpClient.isSecureScheme(requestURI.getScheme());
            String host = requestURI.getHost();
            if (host == null) {
                host = requestURI.getAuthority();
                if (host == null) {
                    throw (NoHostException)ctx.customizeException((HttpClientException)new NoHostException("URI specifies no host to connect to"));
                }
                int i = host.indexOf(58);
                if (i > -1) {
                    String portStr = host.substring(i + 1);
                    host = host.substring(0, i);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw ctx.customizeException(new HttpClientException("URI specifies an invalid port: " + portStr));
                    }
                } else {
                    port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
                }
            } else {
                port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
            }
            this.host = host;
            this.port = port;
        }

        public InetSocketAddress getRemoteAddress() {
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return this.port == that.port && this.secure == that.secure && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.secure);
        }
    }

    @FunctionalInterface
    static interface ThrowingBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Exception;
    }
}

