/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.internal.catalog.sql.Option;
import org.apache.ignite.internal.catalog.sql.QueryUtils;
import org.apache.ignite.internal.catalog.sql.SelectFromView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.sql.IgniteSql;

public class TableDefinitionCollector {
    private static final List<String> TABLE_VIEW_COLUMNS = List.of("SCHEMA", "PK_INDEX_ID", "ZONE", "COLOCATION_KEY_INDEX");
    private static final List<String> INDEX_VIEW_COLUMNS = List.of("INDEX_ID", "INDEX_NAME", "COLUMNS", "TYPE");
    private static final List<String> TABLE_COLUMNS_VIEW_COLUMNS = List.of("COLUMN_NAME", "TYPE", "LENGTH", "PREC", "SCALE", "NULLABLE");
    private final String tableName;
    private final IgniteSql sql;

    public TableDefinitionCollector(String tableName, IgniteSql sql) {
        this.tableName = tableName;
        this.sql = sql;
    }

    public CompletableFuture<TableDefinition.Builder> collectDefinition() {
        return this.collectTableInfo().thenCompose(builder -> {
            if (builder == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return this.collectIndexes((TableDefinitionBuilderWithIndexId)builder).thenCompose(this::collectColumns);
        });
    }

    private CompletableFuture<TableDefinitionBuilderWithIndexId> collectTableInfo() {
        return new SelectFromView<TableDefinitionBuilderWithIndexId>(this.sql, TABLE_VIEW_COLUMNS, "TABLES", Option.name(this.tableName), row -> {
            String schema = row.stringValue("SCHEMA");
            int indexId = row.intValue("PK_INDEX_ID");
            String zone = row.stringValue("ZONE");
            String colocationColumns = row.stringValue("COLOCATION_KEY_INDEX");
            TableDefinition.Builder builder = TableDefinition.builder((String)this.tableName).schema(schema).zone(zone).colocateBy(QueryUtils.splitByComma(colocationColumns));
            return new TableDefinitionBuilderWithIndexId(builder, indexId);
        }).executeAsync().thenApply(definitions -> {
            if (definitions.isEmpty()) {
                return null;
            }
            assert (definitions.size() == 1);
            return (TableDefinitionBuilderWithIndexId)definitions.get(0);
        });
    }

    private CompletableFuture<TableDefinition.Builder> collectIndexes(TableDefinitionBuilderWithIndexId tableDefinitionWithPkIndexId) {
        return new SelectFromView<Index>(this.sql, INDEX_VIEW_COLUMNS, "INDEXES", Option.tableName(this.tableName), row -> {
            int pkIndexId = tableDefinitionWithPkIndexId.indexId;
            int indexId = row.intValue("INDEX_ID");
            String indexName = row.stringValue("INDEX_NAME");
            String columns = row.stringValue("COLUMNS");
            String type = row.stringValue("TYPE");
            return Index.create(indexName, type, columns, indexId == pkIndexId);
        }).executeAsync().thenApply(indexes -> {
            TableDefinition.Builder builder = tableDefinitionWithPkIndexId.builder;
            for (Index index : indexes) {
                if (index.isPkIndex) {
                    builder.primaryKey(index.type, index.columns);
                    continue;
                }
                builder.index(index.name, index.type, index.columns);
            }
            return builder;
        });
    }

    private CompletableFuture<TableDefinition.Builder> collectColumns(TableDefinition.Builder builder) {
        return new SelectFromView<ColumnDefinition>(this.sql, TABLE_COLUMNS_VIEW_COLUMNS, "TABLE_COLUMNS", Option.tableName(this.tableName), row -> {
            String columnName = row.stringValue("COLUMN_NAME");
            String type = row.stringValue("TYPE");
            int length = row.intValue("LENGTH");
            int precision = row.intValue("PREC");
            int scale = row.intValue("SCALE");
            boolean nullable = row.booleanValue("NULLABLE");
            Class typeClass = org.apache.ignite.sql.ColumnType.valueOf((String)type).javaClass();
            return ColumnDefinition.column((String)columnName, (ColumnType)ColumnType.of((Class)typeClass, (Integer)length, (Integer)precision, (Integer)scale, (Boolean)nullable));
        }).executeAsync().thenApply(arg_0 -> ((TableDefinition.Builder)builder).columns(arg_0));
    }

    private static List<ColumnSorted> fromRaw(String columns) {
        return Arrays.stream(columns.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(ColumnSorted::column).collect(Collectors.toList());
    }

    private static class TableDefinitionBuilderWithIndexId {
        private final TableDefinition.Builder builder;
        private final int indexId;

        private TableDefinitionBuilderWithIndexId(TableDefinition.Builder builder, int indexId) {
            this.builder = builder;
            this.indexId = indexId;
        }
    }

    private static class Index {
        private final String name;
        private final IndexType type;
        private final List<ColumnSorted> columns;
        private final boolean isPkIndex;

        private Index(String name, IndexType type, List<ColumnSorted> columns, boolean isPkIndex) {
            this.name = name;
            this.type = type;
            this.columns = columns;
            this.isPkIndex = isPkIndex;
        }

        private static Index create(String name, String type, String columns, boolean isPkIndex) {
            return new Index(name, IndexType.valueOf((String)type), TableDefinitionCollector.fromRaw(columns), isPkIndex);
        }
    }
}

