/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.algorithm.util;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.aggdes.algorithm.Progress;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.model.Parameter;

public class ArgumentUtils {
    public static Map<Parameter, Object> validateParameters(Component component, Map<String, String> rawParams) {
        List<Parameter> parameterList = component.getParameters();
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        HashMap<Parameter, Object> parameterValues = new HashMap<Parameter, Object>();
        for (Parameter parameter : parameterList) {
            parameters.put(parameter.getName(), parameter);
        }
        block11: for (Map.Entry entry : rawParams.entrySet()) {
            String name = (String)entry.getKey();
            Parameter parameter = (Parameter)parameters.get(name);
            if (parameter == null) {
                throw new ValidationException(component, "Unknown parameter '" + name + "' for component " + component.getName());
            }
            String value = (String)entry.getValue();
            switch (parameter.getType()) {
                case STRING: {
                    parameterValues.put(parameter, value);
                    continue block11;
                }
                case INTEGER: {
                    try {
                        int intValue = Integer.parseInt(value);
                        parameterValues.put(parameter, intValue);
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException(component, "Cannot convert parameter '" + name + "' to integer");
                    }
                }
                case DOUBLE: {
                    try {
                        double doubleValue = Double.parseDouble(value);
                        parameterValues.put(parameter, doubleValue);
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException(component, "Cannot convert parameter '" + name + "' to double");
                    }
                }
                case BOOLEAN: {
                    boolean booleanValue = Boolean.parseBoolean(value);
                    parameterValues.put(parameter, booleanValue);
                    continue block11;
                }
            }
            throw new IllegalArgumentException((Object)((Object)parameter.getType()) + "");
        }
        for (Parameter parameter : parameterList) {
            if (!parameter.isRequired() || parameterValues.get(parameter) != null) continue;
            throw new ValidationException(component, "Missing value for required parameter '" + parameter.getName() + "' of component " + component.getName());
        }
        return parameterValues;
    }

    public static class ValidationException
    extends RuntimeException {
        private static final long serialVersionUID = 5181014746393411408L;
        private final Component component;

        public ValidationException(Component component, String message) {
            super(message);
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    public static class TextProgress
    implements Progress {
        private final PrintWriter pw;

        public TextProgress(PrintWriter pw) {
            this.pw = pw;
        }

        @Override
        public void report(String message, double complete) {
            int percent = (int)(complete * 100.0);
            this.pw.println(percent + "% complete" + (message == null ? "" : "; " + message));
        }
    }
}

