/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionMapping;

class ClientCachePartitionAwarenessGroup {
    CacheObjectBinaryProcessorImpl proc;
    private final ClientCachePartitionMapping mapping;
    private HashMap<Integer, CacheConfiguration> cacheCfgs;

    public ClientCachePartitionAwarenessGroup(CacheObjectBinaryProcessorImpl proc, ClientCachePartitionMapping mapping, DynamicCacheDescriptor cacheDesc) {
        this.proc = proc;
        this.mapping = mapping;
        int cacheId = cacheDesc.cacheId();
        CacheConfiguration ccfg = cacheDesc.cacheConfiguration();
        this.cacheCfgs = new HashMap();
        this.cacheCfgs.put(cacheId, ccfg);
    }

    public boolean isCompatible(ClientCachePartitionMapping mapping) {
        if (this.mapping == null || mapping == null) {
            return this.mapping == mapping;
        }
        return mapping.isCompatible(mapping);
    }

    public void write(BinaryRawWriter writer) {
        writer.writeBoolean(this.mapping != null);
        writer.writeInt(this.cacheCfgs.size());
        for (Map.Entry<Integer, CacheConfiguration> entry : this.cacheCfgs.entrySet()) {
            writer.writeInt(entry.getKey());
            if (this.mapping == null) continue;
            CacheConfiguration ccfg = entry.getValue();
            CacheKeyConfiguration[] keyCfgs = ccfg.getKeyConfiguration();
            if (keyCfgs == null) {
                writer.writeInt(0);
                continue;
            }
            writer.writeInt(keyCfgs.length);
            for (CacheKeyConfiguration keyCfg : keyCfgs) {
                int keyTypeId = this.proc.typeId(keyCfg.getTypeName());
                int affinityKeyFieldId = this.proc.binaryContext().fieldId(keyTypeId, keyCfg.getAffinityKeyFieldName());
                writer.writeInt(keyTypeId);
                writer.writeInt(affinityKeyFieldId);
            }
        }
        if (this.mapping != null) {
            this.mapping.write(writer);
        }
    }

    public void addCache(DynamicCacheDescriptor desc) {
        this.cacheCfgs.put(desc.cacheId(), desc.cacheConfiguration());
    }
}

