/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.binary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.binary.VisorBinaryMetadataField;
import org.jetbrains.annotations.Nullable;

public class VisorBinaryMetadata
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String typeName;
    private int typeId;
    private String affinityKeyFieldName;
    private List<VisorBinaryMetadataField> fields;

    public static List<VisorBinaryMetadata> list(IgniteBinary binary) {
        ArrayList<VisorBinaryMetadata> res = new ArrayList<VisorBinaryMetadata>();
        if (binary != null) {
            for (BinaryType binaryType : binary.types()) {
                res.add(new VisorBinaryMetadata(binary, binaryType));
            }
        }
        return res;
    }

    public VisorBinaryMetadata() {
    }

    public VisorBinaryMetadata(IgniteBinary binary, BinaryType binaryType) {
        this.typeName = binaryType.typeName();
        this.typeId = binary.typeId(this.typeName);
        this.affinityKeyFieldName = binaryType.affinityKeyFieldName();
        Collection<String> binaryTypeFields = binaryType.fieldNames();
        this.fields = new ArrayList<VisorBinaryMetadataField>(binaryTypeFields.size());
        for (String metaField : binaryTypeFields) {
            this.fields.add(new VisorBinaryMetadataField(metaField, binaryType.fieldTypeName(metaField), null));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public Collection<VisorBinaryMetadataField> getFields() {
        return this.fields;
    }

    @Nullable
    public String getAffinityKeyFieldName() {
        return this.affinityKeyFieldName;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.typeName);
        out.writeInt(this.typeId);
        U.writeString(out, this.affinityKeyFieldName);
        U.writeCollection(out, this.fields);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = U.readString(in);
        this.typeId = in.readInt();
        this.affinityKeyFieldName = U.readString(in);
        this.fields = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorBinaryMetadata.class, this);
    }
}

