/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.server;

import org.apache.gravitino.Config;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.iceberg.RESTService;
import org.apache.gravitino.server.ServerConfig;
import org.apache.gravitino.server.authentication.ServerAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoIcebergRESTServer {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoIcebergRESTServer.class);
    public static final String CONF_FILE = "gravitino-iceberg-rest-server.conf";
    private final Config serverConfig;
    private RESTService icebergRESTService;
    private GravitinoEnv gravitinoEnv;

    public GravitinoIcebergRESTServer(Config config) {
        this.serverConfig = config;
        this.gravitinoEnv = GravitinoEnv.getInstance();
        this.icebergRESTService = new RESTService();
    }

    private void initialize() {
        this.gravitinoEnv.initialize(this.serverConfig, false);
        this.icebergRESTService.serviceInit(this.serverConfig.getConfigsWithPrefix("gravitino.iceberg-rest."));
        ServerAuthenticator.getInstance().initialize(this.serverConfig);
    }

    private void start() {
        this.icebergRESTService.serviceStart();
    }

    private void join() {
        this.icebergRESTService.join();
    }

    private void stop() throws Exception {
        this.icebergRESTService.serviceStop();
        LOG.info("Gravitino Iceberg REST service stopped");
    }

    public static void main(String[] args) {
        LOG.info("Starting Gravitino Iceberg REST Server");
        String confPath = System.getenv("GRAVITINO_TEST") == null ? "" : args[0];
        ServerConfig serverConfig = ServerConfig.loadConfig((String)confPath, (String)CONF_FILE);
        GravitinoIcebergRESTServer icebergRESTServer = new GravitinoIcebergRESTServer((Config)serverConfig);
        icebergRESTServer.initialize();
        try {
            icebergRESTServer.start();
        }
        catch (Exception e) {
            LOG.error("Error while running jettyServer", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Done, Gravitino Iceberg REST server started.");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Thread.sleep(((Integer)serverConfig.get(ServerConfig.SERVER_SHUTDOWN_TIMEOUT)).intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupted exception:", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Error while running clean-up tasks in shutdown hook", (Throwable)e);
            }
        }));
        icebergRESTServer.join();
        LOG.info("Shutting down Gravitino Iceberg REST Server ... ");
        try {
            icebergRESTServer.stop();
            LOG.info("Gravitino Iceberg REST Server has shut down.");
        }
        catch (Exception e) {
            LOG.error("Error while stopping Gravitino Iceberg REST Server", (Throwable)e);
        }
    }
}

