/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.EntitySerDe;
import org.apache.gravitino.proto.ProtoEntitySerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerDeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySerDeFactory.class);
    private static final Map<String, String> ENTITY_SERDES = ImmutableMap.of((Object)"proto", (Object)ProtoEntitySerDe.class.getCanonicalName());

    private EntitySerDeFactory() {
    }

    public static EntitySerDe createEntitySerDe(Config config) {
        String name = config.get(Configs.ENTITY_SERDE);
        return EntitySerDeFactory.createEntitySerDe(name);
    }

    public static EntitySerDe createEntitySerDe(String name) {
        String className = ENTITY_SERDES.getOrDefault(name, name);
        try {
            return (EntitySerDe)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Failed to create EntitySerDe by name {}.", (Object)name, (Object)e);
            throw new RuntimeException("Failed to create EntitySerDe: " + name, e);
        }
    }
}

