/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

@Evolving
public interface SupportsCatalogs {
    public NameIdentifier[] listCatalogs(Namespace var1) throws NoSuchMetalakeException;

    public Catalog[] listCatalogsInfo(Namespace var1) throws NoSuchMetalakeException;

    public Catalog loadCatalog(NameIdentifier var1) throws NoSuchCatalogException;

    default public boolean catalogExists(NameIdentifier ident) {
        try {
            this.loadCatalog(ident);
            return true;
        }
        catch (NoSuchCatalogException e) {
            return false;
        }
    }

    public Catalog createCatalog(NameIdentifier var1, Catalog.Type var2, String var3, String var4, Map<String, String> var5) throws NoSuchMetalakeException, CatalogAlreadyExistsException;

    public Catalog alterCatalog(NameIdentifier var1, CatalogChange ... var2) throws NoSuchCatalogException, IllegalArgumentException;

    public boolean dropCatalog(NameIdentifier var1);

    public void testConnection(NameIdentifier var1, Catalog.Type var2, String var3, String var4, Map<String, String> var5) throws Exception;
}

