/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.metalake.MetalakeDispatcher;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class MetalakeHookDispatcher
implements MetalakeDispatcher {
    private final MetalakeDispatcher dispatcher;

    public MetalakeHookDispatcher(MetalakeDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public Metalake[] listMetalakes() {
        return this.dispatcher.listMetalakes();
    }

    @Override
    public Metalake loadMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        return this.dispatcher.loadMetalake(ident);
    }

    @Override
    public Metalake createMetalake(NameIdentifier ident, String comment, Map<String, String> properties) throws MetalakeAlreadyExistsException {
        OwnerManager ownerManager;
        Metalake metalake = this.dispatcher.createMetalake(ident, comment, properties);
        AccessControlDispatcher accessControlDispatcher = GravitinoEnv.getInstance().accessControlDispatcher();
        if (accessControlDispatcher != null) {
            accessControlDispatcher.addUser(ident.name(), PrincipalUtils.getCurrentUserName());
        }
        if ((ownerManager = GravitinoEnv.getInstance().ownerManager()) != null) {
            ownerManager.setOwner(ident.name(), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.METALAKE), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return metalake;
    }

    @Override
    public Metalake alterMetalake(NameIdentifier ident, MetalakeChange ... changes) throws NoSuchMetalakeException, IllegalArgumentException {
        return this.dispatcher.alterMetalake(ident, changes);
    }

    @Override
    public boolean dropMetalake(NameIdentifier ident) {
        return this.dispatcher.dropMetalake(ident);
    }

    @Override
    public boolean metalakeExists(NameIdentifier ident) {
        return this.dispatcher.metalakeExists(ident);
    }
}

