/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.ProtoSerDe;
import org.apache.gravitino.proto.Schema;

public class SchemaEntitySerDe
implements ProtoSerDe<SchemaEntity, Schema> {
    @Override
    public Schema serialize(SchemaEntity schemaEntity) {
        Schema.Builder builder = Schema.newBuilder().setId(schemaEntity.id().longValue()).setName(schemaEntity.name()).setAuditInfo(new AuditInfoSerDe().serialize(schemaEntity.auditInfo()));
        if (schemaEntity.comment() != null) {
            builder.setComment(schemaEntity.comment());
        }
        if (schemaEntity.properties() != null && !schemaEntity.properties().isEmpty()) {
            builder.putAllProperties(schemaEntity.properties());
        }
        return builder.build();
    }

    @Override
    public SchemaEntity deserialize(Schema p, Namespace namespace) {
        SchemaEntity.Builder builder = SchemaEntity.builder().withId(p.getId()).withName(p.getName()).withNamespace(namespace).withAuditInfo(new AuditInfoSerDe().deserialize(p.getAuditInfo(), namespace));
        if (p.hasComment()) {
            builder.withComment(p.getComment());
        }
        if (p.getPropertiesCount() > 0) {
            builder.withProperties(p.getPropertiesMap());
        }
        return builder.build();
    }
}

